/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.http2.MultiplexedChannelRecord;
import software.amazon.awssdk.http.nio.netty.internal.http2.PingTracker;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;
import software.amazon.awssdk.utils.Logger;

@ChannelHandler.Sharable
@SdkInternalApi
public final class Http2FrameExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final Http2FrameExceptionHandler INSTANCE = new Http2FrameExceptionHandler();
    private static final Http2PingFrame DEFAULT_PING_FRAME = new DefaultHttp2PingFrame(0L);
    private static final Logger log = Logger.loggerFor(Http2FrameExceptionHandler.class);

    private Http2FrameExceptionHandler() {
    }

    public static Http2FrameExceptionHandler create() {
        return INSTANCE;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if ((cause instanceof ReadTimeoutException || cause instanceof WriteTimeoutException) && ctx.channel().parent() != null) {
            Channel parent = ctx.channel().parent();
            NettyUtils.doInEventLoop((EventExecutor)parent.eventLoop(), () -> this.healthCheckIfNotAlready(parent));
        }
        ctx.fireExceptionCaught(cause);
    }

    private void healthCheckIfNotAlready(Channel parent) {
        if (parent.attr(ChannelAttributeKey.PING_TRACKER).get() != null) {
            return;
        }
        log.debug(() -> "Read/WriteTimeoutException occurred, sending PING frame to " + parent);
        Supplier<ScheduledFuture<?>> pingTimerFutureSupplier = () -> parent.eventLoop().schedule(() -> this.timeoutHealthCheck(parent), 5L, TimeUnit.SECONDS);
        PingTracker pingTracker = new PingTracker(pingTimerFutureSupplier);
        parent.attr(ChannelAttributeKey.PING_TRACKER).set((Object)pingTracker);
        parent.writeAndFlush((Object)DEFAULT_PING_FRAME).addListener(res -> {
            if (!res.isSuccess()) {
                log.debug(() -> "Failed to write and flush PING frame to connection", res.cause());
                pingTracker.cancel();
                this.closeH2Connection(parent, PingFailedException.PING_WRITE_FAILED_INSTANCE);
            }
        });
        pingTracker.start();
    }

    private void timeoutHealthCheck(Channel parentChannel) {
        log.debug(() -> String.format("Has not received PING ACK within %s seconds, closing the connection %s", 5, parentChannel));
        this.closeH2Connection(parentChannel, PingFailedException.PING_NOT_ACK_INSTANCE);
    }

    private void closeH2Connection(Channel parent, PingFailedException exception) {
        MultiplexedChannelRecord channelRecord = (MultiplexedChannelRecord)parent.attr(ChannelAttributeKey.CHANNEL_POOL_RECORD).get();
        channelRecord.shutdownChildChannels(exception);
        parent.close();
    }

    static final class PingFailedException
    extends IOException {
        static final PingFailedException PING_WRITE_FAILED_INSTANCE = new PingFailedException("Failed to send PING to the service");
        static final PingFailedException PING_NOT_ACK_INSTANCE = new PingFailedException(String.format("Failed to receive PING ACK from the service within %s seconds", 5));

        private PingFailedException(String msg) {
            super(msg);
        }
    }
}

