/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.http2.GoAwayException;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class MultiplexedChannelRecord {
    private static final Logger log = Logger.loggerFor(MultiplexedChannelRecord.class);
    private final Channel connection;
    private final long maxConcurrencyPerConnection;
    private final AtomicLong availableChildChannels;
    private final Map<ChannelId, Http2StreamChannel> childChannels = new HashMap<ChannelId, Http2StreamChannel>();
    private volatile RecordState state = RecordState.OPEN;

    MultiplexedChannelRecord(Channel connection, long maxConcurrencyPerConnection) {
        this.connection = connection;
        this.maxConcurrencyPerConnection = maxConcurrencyPerConnection;
        this.availableChildChannels = new AtomicLong(maxConcurrencyPerConnection);
    }

    boolean acquireStream(Promise<Channel> promise) {
        if (this.claimStream()) {
            this.releaseClaimOnFailure(promise);
            this.acquireClaimedStream(promise);
            return true;
        }
        return false;
    }

    private void acquireClaimedStream(Promise<Channel> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.connection.eventLoop(), () -> {
            if (this.state != RecordState.OPEN) {
                String message = "Connection received GOAWAY or was closed while acquiring new stream.";
                promise.setFailure((Throwable)new IllegalStateException(message));
                return;
            }
            Future streamFuture = new Http2StreamChannelBootstrap(this.connection).open();
            streamFuture.addListener(future -> {
                NettyUtils.warnIfNotInEventLoop(this.connection.eventLoop());
                if (!future.isSuccess()) {
                    promise.setFailure(future.cause());
                    return;
                }
                Http2StreamChannel channel = (Http2StreamChannel)future.getNow();
                this.childChannels.put(channel.id(), channel);
                promise.setSuccess((Object)channel);
            });
        }, promise);
    }

    private void releaseClaimOnFailure(Promise<Channel> promise) {
        try {
            promise.addListener(f -> {
                if (!promise.isSuccess()) {
                    this.releaseClaim();
                }
            });
        }
        catch (Throwable e) {
            this.releaseClaim();
            throw e;
        }
    }

    private void releaseClaim() {
        if (this.availableChildChannels.incrementAndGet() > this.maxConcurrencyPerConnection) {
            assert (false);
            log.warn(() -> "Child channel count was caught attempting to be increased over max concurrency. Please report this issue to the AWS SDK for Java team.");
            this.availableChildChannels.decrementAndGet();
        }
    }

    void handleGoAway(int lastStreamId, GoAwayException exception) {
        NettyUtils.doInEventLoop((EventExecutor)this.connection.eventLoop(), () -> {
            if (this.state == RecordState.CLOSED) {
                return;
            }
            if (this.state == RecordState.OPEN) {
                this.state = RecordState.CLOSED_TO_NEW;
            }
            ArrayList<Http2StreamChannel> childrenToClose = new ArrayList<Http2StreamChannel>(this.childChannels.values());
            childrenToClose.stream().filter(cc -> cc.stream().id() > lastStreamId).forEach(cc -> cc.pipeline().fireExceptionCaught((Throwable)exception));
        });
    }

    void closeChildChannels() {
        this.closeAndExecuteOnChildChannels(ch -> ch.close());
    }

    void closeChildChannels(Throwable t) {
        this.closeAndExecuteOnChildChannels(ch -> ch.pipeline().fireExceptionCaught(t));
    }

    private void closeAndExecuteOnChildChannels(Consumer<Channel> childChannelConsumer) {
        NettyUtils.doInEventLoop((EventExecutor)this.connection.eventLoop(), () -> {
            if (this.state == RecordState.CLOSED) {
                return;
            }
            this.state = RecordState.CLOSED;
            ArrayList<Http2StreamChannel> childrenToClose = new ArrayList<Http2StreamChannel>(this.childChannels.values());
            for (Channel channel : childrenToClose) {
                childChannelConsumer.accept(channel);
            }
        });
    }

    public void closeAndReleaseChild(Channel childChannel) {
        childChannel.close();
        NettyUtils.doInEventLoop((EventExecutor)this.connection.eventLoop(), () -> {
            this.childChannels.remove(childChannel.id());
            this.releaseClaim();
        });
    }

    public Channel getConnection() {
        return this.connection;
    }

    public boolean claimStream() {
        for (int attempt = 0; attempt < 5; ++attempt) {
            if (this.state != RecordState.OPEN || this.pingInFlight()) {
                return false;
            }
            long currentlyAvailable = this.availableChildChannels.get();
            if (currentlyAvailable <= 0L) {
                return false;
            }
            if (!this.availableChildChannels.compareAndSet(currentlyAvailable, currentlyAvailable - 1L)) continue;
            return true;
        }
        return false;
    }

    private boolean pingInFlight() {
        return this.connection.attr(ChannelAttributeKey.PING_TRACKER).get() != null;
    }

    boolean canBeClosedAndReleased() {
        return this.state != RecordState.OPEN && this.availableChildChannels.get() == this.maxConcurrencyPerConnection;
    }

    private static enum RecordState {
        OPEN,
        CLOSED_TO_NEW,
        CLOSED;

    }
}

