/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http2.ForkedHttp2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.FutureCancelHandler;
import software.amazon.awssdk.http.nio.netty.internal.IdleConnectionReaperHandler;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.OldConnectionReaperHandler;
import software.amazon.awssdk.http.nio.netty.internal.SslCloseCompletionEventHandler;
import software.amazon.awssdk.http.nio.netty.internal.UnusedChannelExceptionHandler;
import software.amazon.awssdk.http.nio.netty.internal.http2.Http2SettingsFrameHandler;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class ChannelPipelineInitializer
extends AbstractChannelPoolHandler {
    private final Protocol protocol;
    private final SslContext sslCtx;
    private final long clientMaxStreams;
    private final AtomicReference<ChannelPool> channelPoolRef;
    private final NettyConfiguration configuration;

    public ChannelPipelineInitializer(Protocol protocol, SslContext sslCtx, long clientMaxStreams, AtomicReference<ChannelPool> channelPoolRef, NettyConfiguration configuration) {
        this.protocol = protocol;
        this.sslCtx = sslCtx;
        this.clientMaxStreams = clientMaxStreams;
        this.channelPoolRef = channelPoolRef;
        this.configuration = configuration;
    }

    public void channelCreated(Channel ch) {
        ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).set(new CompletableFuture());
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            pipeline.addLast(new ChannelHandler[]{SslCloseCompletionEventHandler.getInstance()});
        }
        if (this.protocol == Protocol.HTTP2) {
            this.configureHttp2(ch, pipeline);
        } else {
            this.configureHttp11(ch, pipeline);
        }
        if (this.configuration.reapIdleConnections()) {
            pipeline.addLast(new ChannelHandler[]{new IdleConnectionReaperHandler(this.configuration.idleTimeoutMillis())});
        }
        if (this.configuration.connectionTtlMillis() > 0) {
            pipeline.addLast(new ChannelHandler[]{new OldConnectionReaperHandler(this.configuration.connectionTtlMillis())});
        }
        pipeline.addLast(new ChannelHandler[]{FutureCancelHandler.getInstance()});
        pipeline.addLast(new ChannelHandler[]{UnusedChannelExceptionHandler.getInstance()});
        pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
    }

    private void configureHttp2(Channel ch, ChannelPipeline pipeline) {
        ForkedHttp2MultiplexCodecBuilder codecBuilder = ForkedHttp2MultiplexCodecBuilder.forClient((ChannelHandler)new NoOpChannelInitializer()).headerSensitivityDetector((name, value) -> StringUtils.lowerCase((String)name.toString()).equals("authorization")).initialSettings(Http2Settings.defaultSettings().initialWindowSize(0x100000));
        codecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG));
        pipeline.addLast(new ChannelHandler[]{codecBuilder.build()});
        pipeline.addLast(new ChannelHandler[]{new Http2SettingsFrameHandler(ch, this.clientMaxStreams, this.channelPoolRef)});
    }

    private void configureHttp11(Channel ch, ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        ((CompletableFuture)ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).complete(Protocol.HTTP1_1);
    }

    private static class NoOpChannelInitializer
    extends ChannelInitializer<Channel> {
        private NoOpChannelInitializer() {
        }

        protected void initChannel(Channel ch) {
        }
    }
}

