/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFirewallPolicyRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateFirewallPolicyRequest> {
    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyName").getter(CreateFirewallPolicyRequest.getter(CreateFirewallPolicyRequest::firewallPolicyName)).setter(CreateFirewallPolicyRequest.setter(Builder::firewallPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build()}).build();
    private static final SdkField<FirewallPolicy> FIREWALL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallPolicy").getter(CreateFirewallPolicyRequest.getter(CreateFirewallPolicyRequest::firewallPolicy)).setter(CreateFirewallPolicyRequest.setter(Builder::firewallPolicy)).constructor(FirewallPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFirewallPolicyRequest.getter(CreateFirewallPolicyRequest::description)).setter(CreateFirewallPolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFirewallPolicyRequest.getter(CreateFirewallPolicyRequest::tags)).setter(CreateFirewallPolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateFirewallPolicyRequest.getter(CreateFirewallPolicyRequest::dryRun)).setter(CreateFirewallPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_NAME_FIELD, FIREWALL_POLICY_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, DRY_RUN_FIELD));
    private final String firewallPolicyName;
    private final FirewallPolicy firewallPolicy;
    private final String description;
    private final List<Tag> tags;
    private final Boolean dryRun;

    private CreateFirewallPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicy = builder.firewallPolicy;
        this.description = builder.description;
        this.tags = builder.tags;
        this.dryRun = builder.dryRun;
    }

    public String firewallPolicyName() {
        return this.firewallPolicyName;
    }

    public FirewallPolicy firewallPolicy() {
        return this.firewallPolicy;
    }

    public String description() {
        return this.description;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallPolicyRequest)) {
            return false;
        }
        CreateFirewallPolicyRequest other = (CreateFirewallPolicyRequest)((Object)obj);
        return Objects.equals(this.firewallPolicyName(), other.firewallPolicyName()) && Objects.equals(this.firewallPolicy(), other.firewallPolicy()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"CreateFirewallPolicyRequest").add("FirewallPolicyName", (Object)this.firewallPolicyName()).add("FirewallPolicy", (Object)this.firewallPolicy()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallPolicyName": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyName()));
            }
            case "FirewallPolicy": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicy()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallPolicyRequest, T> g) {
        return obj -> g.apply((CreateFirewallPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallPolicyName;
        private FirewallPolicy firewallPolicy;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallPolicyRequest model) {
            super(model);
            this.firewallPolicyName(model.firewallPolicyName);
            this.firewallPolicy(model.firewallPolicy);
            this.description(model.description);
            this.tags(model.tags);
            this.dryRun(model.dryRun);
        }

        public final String getFirewallPolicyName() {
            return this.firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        public final FirewallPolicy.Builder getFirewallPolicy() {
            return this.firewallPolicy != null ? this.firewallPolicy.toBuilder() : null;
        }

        @Override
        public final Builder firewallPolicy(FirewallPolicy firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        public final void setFirewallPolicy(FirewallPolicy.BuilderImpl firewallPolicy) {
            this.firewallPolicy = firewallPolicy != null ? firewallPolicy.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFirewallPolicyRequest build() {
            return new CreateFirewallPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFirewallPolicyRequest> {
        public Builder firewallPolicyName(String var1);

        public Builder firewallPolicy(FirewallPolicy var1);

        default public Builder firewallPolicy(Consumer<FirewallPolicy.Builder> firewallPolicy) {
            return this.firewallPolicy((FirewallPolicy)((FirewallPolicy.Builder)FirewallPolicy.builder().applyMutation(firewallPolicy)).build());
        }

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

