/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroup;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupType;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRuleGroupRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupName").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::ruleGroupName)).setter(CreateRuleGroupRequest.setter(Builder::ruleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()}).build();
    private static final SdkField<RuleGroup> RULE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleGroup").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::ruleGroup)).setter(CreateRuleGroupRequest.setter(Builder::ruleGroup)).constructor(RuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()}).build();
    private static final SdkField<String> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rules").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::rules)).setter(CreateRuleGroupRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::typeAsString)).setter(CreateRuleGroupRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::description)).setter(CreateRuleGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Capacity").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::capacity)).setter(CreateRuleGroupRequest.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::tags)).setter(CreateRuleGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateRuleGroupRequest.getter(CreateRuleGroupRequest::dryRun)).setter(CreateRuleGroupRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_NAME_FIELD, RULE_GROUP_FIELD, RULES_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, CAPACITY_FIELD, TAGS_FIELD, DRY_RUN_FIELD));
    private final String ruleGroupName;
    private final RuleGroup ruleGroup;
    private final String rules;
    private final String type;
    private final String description;
    private final Integer capacity;
    private final List<Tag> tags;
    private final Boolean dryRun;

    private CreateRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroup = builder.ruleGroup;
        this.rules = builder.rules;
        this.type = builder.type;
        this.description = builder.description;
        this.capacity = builder.capacity;
        this.tags = builder.tags;
        this.dryRun = builder.dryRun;
    }

    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    public RuleGroup ruleGroup() {
        return this.ruleGroup;
    }

    public String rules() {
        return this.rules;
    }

    public RuleGroupType type() {
        return RuleGroupType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleGroupRequest)) {
            return false;
        }
        CreateRuleGroupRequest other = (CreateRuleGroupRequest)((Object)obj);
        return Objects.equals(this.ruleGroupName(), other.ruleGroupName()) && Objects.equals(this.ruleGroup(), other.ruleGroup()) && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.capacity(), other.capacity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"CreateRuleGroupRequest").add("RuleGroupName", (Object)this.ruleGroupName()).add("RuleGroup", (Object)this.ruleGroup()).add("Rules", (Object)this.rules()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Capacity", (Object)this.capacity()).add("Tags", this.hasTags() ? this.tags() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupName()));
            }
            case "RuleGroup": {
                return Optional.ofNullable(clazz.cast(this.ruleGroup()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleGroupRequest, T> g) {
        return obj -> g.apply((CreateRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String ruleGroupName;
        private RuleGroup ruleGroup;
        private String rules;
        private String type;
        private String description;
        private Integer capacity;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleGroupRequest model) {
            super(model);
            this.ruleGroupName(model.ruleGroupName);
            this.ruleGroup(model.ruleGroup);
            this.rules(model.rules);
            this.type(model.type);
            this.description(model.description);
            this.capacity(model.capacity);
            this.tags(model.tags);
            this.dryRun(model.dryRun);
        }

        public final String getRuleGroupName() {
            return this.ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        public final RuleGroup.Builder getRuleGroup() {
            return this.ruleGroup != null ? this.ruleGroup.toBuilder() : null;
        }

        @Override
        public final Builder ruleGroup(RuleGroup ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final void setRuleGroup(RuleGroup.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        public final String getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(String rules) {
            this.rules = rules;
            return this;
        }

        public final void setRules(String rules) {
            this.rules = rules;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleGroupRequest build() {
            return new CreateRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRuleGroupRequest> {
        public Builder ruleGroupName(String var1);

        public Builder ruleGroup(RuleGroup var1);

        default public Builder ruleGroup(Consumer<RuleGroup.Builder> ruleGroup) {
            return this.ruleGroup((RuleGroup)((RuleGroup.Builder)RuleGroup.builder().applyMutation(ruleGroup)).build());
        }

        public Builder rules(String var1);

        public Builder type(String var1);

        public Builder type(RuleGroupType var1);

        public Builder description(String var1);

        public Builder capacity(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

