/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFirewallPolicyRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DescribeFirewallPolicyRequest> {
    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyName").getter(DescribeFirewallPolicyRequest.getter(DescribeFirewallPolicyRequest::firewallPolicyName)).setter(DescribeFirewallPolicyRequest.setter(Builder::firewallPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyArn").getter(DescribeFirewallPolicyRequest.getter(DescribeFirewallPolicyRequest::firewallPolicyArn)).setter(DescribeFirewallPolicyRequest.setter(Builder::firewallPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_NAME_FIELD, FIREWALL_POLICY_ARN_FIELD));
    private final String firewallPolicyName;
    private final String firewallPolicyArn;

    private DescribeFirewallPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicyArn = builder.firewallPolicyArn;
    }

    public String firewallPolicyName() {
        return this.firewallPolicyName;
    }

    public String firewallPolicyArn() {
        return this.firewallPolicyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFirewallPolicyRequest)) {
            return false;
        }
        DescribeFirewallPolicyRequest other = (DescribeFirewallPolicyRequest)((Object)obj);
        return Objects.equals(this.firewallPolicyName(), other.firewallPolicyName()) && Objects.equals(this.firewallPolicyArn(), other.firewallPolicyArn());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFirewallPolicyRequest").add("FirewallPolicyName", (Object)this.firewallPolicyName()).add("FirewallPolicyArn", (Object)this.firewallPolicyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallPolicyName": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyName()));
            }
            case "FirewallPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFirewallPolicyRequest, T> g) {
        return obj -> g.apply((DescribeFirewallPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallPolicyName;
        private String firewallPolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFirewallPolicyRequest model) {
            super(model);
            this.firewallPolicyName(model.firewallPolicyName);
            this.firewallPolicyArn(model.firewallPolicyArn);
        }

        public final String getFirewallPolicyName() {
            return this.firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        public final String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFirewallPolicyRequest build() {
            return new DescribeFirewallPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFirewallPolicyRequest> {
        public Builder firewallPolicyName(String var1);

        public Builder firewallPolicyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

