/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFirewallRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DescribeFirewallRequest> {
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(DescribeFirewallRequest.getter(DescribeFirewallRequest::firewallName)).setter(DescribeFirewallRequest.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(DescribeFirewallRequest.getter(DescribeFirewallRequest::firewallArn)).setter(DescribeFirewallRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_NAME_FIELD, FIREWALL_ARN_FIELD));
    private final String firewallName;
    private final String firewallArn;

    private DescribeFirewallRequest(BuilderImpl builder) {
        super(builder);
        this.firewallName = builder.firewallName;
        this.firewallArn = builder.firewallArn;
    }

    public String firewallName() {
        return this.firewallName;
    }

    public String firewallArn() {
        return this.firewallArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFirewallRequest)) {
            return false;
        }
        DescribeFirewallRequest other = (DescribeFirewallRequest)((Object)obj);
        return Objects.equals(this.firewallName(), other.firewallName()) && Objects.equals(this.firewallArn(), other.firewallArn());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFirewallRequest").add("FirewallName", (Object)this.firewallName()).add("FirewallArn", (Object)this.firewallArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFirewallRequest, T> g) {
        return obj -> g.apply((DescribeFirewallRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallName;
        private String firewallArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFirewallRequest model) {
            super(model);
            this.firewallName(model.firewallName);
            this.firewallArn(model.firewallArn);
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFirewallRequest build() {
            return new DescribeFirewallRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFirewallRequest> {
        public Builder firewallName(String var1);

        public Builder firewallArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

