/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.InsufficientCapacityException;
import software.amazon.awssdk.services.networkfirewall.model.InternalServerErrorException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidOperationException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidRequestException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidResourcePolicyException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidTokenException;
import software.amazon.awssdk.services.networkfirewall.model.LimitExceededException;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationPermissionException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkfirewall.model.ResourceOwnerCheckException;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ThrottlingException;
import software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DisassociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallPoliciesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDeleteProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDescriptionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateSubnetChangeProtectionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultNetworkFirewallAsyncClient
implements NetworkFirewallAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetworkFirewallAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNetworkFirewallAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "network-firewall";
    }

    @Override
    public CompletableFuture<AssociateFirewallPolicyResponse> associateFirewallPolicy(AssociateFirewallPolicyRequest associateFirewallPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFirewallPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFirewallPolicy").withMarshaller((Marshaller)new AssociateFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateFirewallPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateFirewallPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$associateFirewallPolicy$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$associateFirewallPolicy$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateSubnetsResponse> associateSubnets(AssociateSubnetsRequest associateSubnetsRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSubnets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSubnetsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSubnets").withMarshaller((Marshaller)new AssociateSubnetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateSubnetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateSubnetsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$associateSubnets$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$associateSubnets$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFirewallResponse> createFirewall(CreateFirewallRequest createFirewallRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFirewallRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFirewall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFirewallResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFirewall").withMarshaller((Marshaller)new CreateFirewallRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFirewallRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFirewallRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$createFirewall$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$createFirewall$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFirewallPolicyResponse> createFirewallPolicy(CreateFirewallPolicyRequest createFirewallPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFirewallPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFirewallPolicy").withMarshaller((Marshaller)new CreateFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFirewallPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFirewallPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$createFirewallPolicy$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$createFirewallPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRuleGroupResponse> createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRuleGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRuleGroup").withMarshaller((Marshaller)new CreateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRuleGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRuleGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$createRuleGroup$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$createRuleGroup$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFirewallResponse> deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFirewallRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFirewall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFirewallResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFirewall").withMarshaller((Marshaller)new DeleteFirewallRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFirewallRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFirewallRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$deleteFirewall$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$deleteFirewall$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFirewallPolicyResponse> deleteFirewallPolicy(DeleteFirewallPolicyRequest deleteFirewallPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFirewallPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFirewallPolicy").withMarshaller((Marshaller)new DeleteFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFirewallPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFirewallPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$deleteFirewallPolicy$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$deleteFirewallPolicy$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteResourcePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$deleteResourcePolicy$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$deleteResourcePolicy$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRuleGroup").withMarshaller((Marshaller)new DeleteRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRuleGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRuleGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$deleteRuleGroup$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$deleteRuleGroup$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFirewallResponse> describeFirewall(DescribeFirewallRequest describeFirewallRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeFirewallRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFirewall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFirewallResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFirewall").withMarshaller((Marshaller)new DescribeFirewallRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFirewallRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeFirewallRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$describeFirewall$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$describeFirewall$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFirewallPolicyResponse> describeFirewallPolicy(DescribeFirewallPolicyRequest describeFirewallPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFirewallPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFirewallPolicy").withMarshaller((Marshaller)new DescribeFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFirewallPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeFirewallPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$describeFirewallPolicy$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$describeFirewallPolicy$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoggingConfigurationResponse> describeLoggingConfiguration(DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLoggingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingConfiguration").withMarshaller((Marshaller)new DescribeLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLoggingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeLoggingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$describeLoggingConfiguration$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$describeLoggingConfiguration$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicy").withMarshaller((Marshaller)new DescribeResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourcePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeResourcePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$describeResourcePolicy$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$describeResourcePolicy$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRuleGroupResponse> describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRuleGroup").withMarshaller((Marshaller)new DescribeRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRuleGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeRuleGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$describeRuleGroup$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$describeRuleGroup$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateSubnetsResponse> disassociateSubnets(DisassociateSubnetsRequest disassociateSubnetsRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociateSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSubnets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSubnetsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSubnets").withMarshaller((Marshaller)new DisassociateSubnetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateSubnetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateSubnetsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$disassociateSubnets$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$disassociateSubnets$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFirewallPoliciesResponse> listFirewallPolicies(ListFirewallPoliciesRequest listFirewallPoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFirewallPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFirewallPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFirewallPoliciesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFirewallPolicies").withMarshaller((Marshaller)new ListFirewallPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFirewallPoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFirewallPoliciesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$listFirewallPolicies$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$listFirewallPolicies$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFirewallPoliciesPublisher listFirewallPoliciesPaginator(ListFirewallPoliciesRequest listFirewallPoliciesRequest) {
        return new ListFirewallPoliciesPublisher(this, this.applyPaginatorUserAgent(listFirewallPoliciesRequest));
    }

    @Override
    public CompletableFuture<ListFirewallsResponse> listFirewalls(ListFirewallsRequest listFirewallsRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFirewallsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFirewalls");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFirewallsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFirewalls").withMarshaller((Marshaller)new ListFirewallsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFirewallsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFirewallsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$listFirewalls$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$listFirewalls$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFirewallsPublisher listFirewallsPaginator(ListFirewallsRequest listFirewallsRequest) {
        return new ListFirewallsPublisher(this, this.applyPaginatorUserAgent(listFirewallsRequest));
    }

    @Override
    public CompletableFuture<ListRuleGroupsResponse> listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleGroupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleGroups").withMarshaller((Marshaller)new ListRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRuleGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRuleGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$listRuleGroups$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$listRuleGroups$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRuleGroupsPublisher listRuleGroupsPaginator(ListRuleGroupsRequest listRuleGroupsRequest) {
        return new ListRuleGroupsPublisher(this, this.applyPaginatorUserAgent(listRuleGroupsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$listTagsForResource$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$listTagsForResource$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putResourcePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$putResourcePolicy$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$putResourcePolicy$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$tagResource$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$tagResource$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$untagResource$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$untagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFirewallDeleteProtectionResponse> updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallDeleteProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallDeleteProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallDeleteProtectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallDeleteProtection").withMarshaller((Marshaller)new UpdateFirewallDeleteProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFirewallDeleteProtectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFirewallDeleteProtectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallDeleteProtection$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallDeleteProtection$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFirewallDescriptionResponse> updateFirewallDescription(UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallDescription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallDescriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallDescription").withMarshaller((Marshaller)new UpdateFirewallDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFirewallDescriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFirewallDescriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallDescription$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallDescription$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFirewallPolicyResponse> updateFirewallPolicy(UpdateFirewallPolicyRequest updateFirewallPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallPolicy").withMarshaller((Marshaller)new UpdateFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFirewallPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFirewallPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallPolicy$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallPolicy$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFirewallPolicyChangeProtectionResponse> updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallPolicyChangeProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallPolicyChangeProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallPolicyChangeProtectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallPolicyChangeProtection").withMarshaller((Marshaller)new UpdateFirewallPolicyChangeProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFirewallPolicyChangeProtectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFirewallPolicyChangeProtectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallPolicyChangeProtection$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateFirewallPolicyChangeProtection$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLoggingConfigurationResponse> updateLoggingConfiguration(UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLoggingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLoggingConfiguration").withMarshaller((Marshaller)new UpdateLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLoggingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateLoggingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateLoggingConfiguration$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateLoggingConfiguration$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuleGroup").withMarshaller((Marshaller)new UpdateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRuleGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRuleGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateRuleGroup$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateRuleGroup$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSubnetChangeProtectionResponse> updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateSubnetChangeProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubnetChangeProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubnetChangeProtectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubnetChangeProtection").withMarshaller((Marshaller)new UpdateSubnetChangeProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSubnetChangeProtectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSubnetChangeProtectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultNetworkFirewallAsyncClient.lambda$updateSubnetChangeProtection$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallAsyncClient.lambda$updateSubnetChangeProtection$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NetworkFirewallException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOperationException").exceptionBuilderSupplier(InvalidOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").exceptionBuilderSupplier(LogDestinationPermissionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").exceptionBuilderSupplier(InsufficientCapacityException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTokenException").exceptionBuilderSupplier(InvalidTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends NetworkFirewallRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.82").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NetworkFirewallRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private static /* synthetic */ void lambda$updateSubnetChangeProtection$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSubnetChangeProtection$85(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSubnetChangeProtectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRuleGroup$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRuleGroup$82(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLoggingConfiguration$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLoggingConfiguration$79(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFirewallPolicyChangeProtection$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallPolicyChangeProtection$76(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFirewallPolicyChangeProtectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFirewallPolicy$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallPolicy$73(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFirewallPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFirewallDescription$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallDescription$70(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFirewallDescriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFirewallDeleteProtection$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallDeleteProtection$67(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFirewallDeleteProtectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$64(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$58(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$55(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRuleGroups$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleGroups$52(List metricPublishers, MetricCollector apiCallMetricCollector, ListRuleGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFirewalls$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFirewalls$49(List metricPublishers, MetricCollector apiCallMetricCollector, ListFirewallsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFirewallPolicies$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFirewallPolicies$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListFirewallPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateSubnets$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateSubnets$43(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateSubnetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRuleGroup$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRuleGroup$40(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$37(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLoggingConfiguration$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoggingConfiguration$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFirewallPolicy$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFirewallPolicy$31(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFirewallPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFirewall$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFirewall$28(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFirewallResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRuleGroup$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRuleGroup$25(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFirewallPolicy$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFirewallPolicy$19(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFirewallPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFirewall$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFirewall$16(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFirewallResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRuleGroup$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRuleGroup$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFirewallPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFirewallPolicy$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFirewallPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFirewall$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFirewall$7(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFirewallResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateSubnets$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSubnets$4(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateSubnetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateFirewallPolicy$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFirewallPolicy$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateFirewallPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

