/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFirewallPolicyResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<CreateFirewallPolicyResponse.Builder, CreateFirewallPolicyResponse> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(CreateFirewallPolicyResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<FirewallPolicyResponse> FIREWALL_POLICY_RESPONSE_FIELD = SdkField
            .<FirewallPolicyResponse> builder(MarshallingType.SDK_POJO).memberName("FirewallPolicyResponse")
            .getter(getter(CreateFirewallPolicyResponse::firewallPolicyResponse)).setter(setter(Builder::firewallPolicyResponse))
            .constructor(FirewallPolicyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyResponse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD,
            FIREWALL_POLICY_RESPONSE_FIELD));

    private final String updateToken;

    private final FirewallPolicyResponse firewallPolicyResponse;

    private CreateFirewallPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.firewallPolicyResponse = builder.firewallPolicyResponse;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall
     * policy. The token marks the state of the policy resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure
     * that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an
     * <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of
     * it with current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         firewall policy. The token marks the state of the policy resource at the time of the request. </p>
     *         <p>
     *         To make changes to the policy, you provide the token in your request. Network Firewall uses the token to
     *         ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails
     *         with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a
     *         current copy of it with current token. Reapply your changes as needed, then try the operation again using
     *         the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * <p>
     * The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy.
     * You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.
     * </p>
     * 
     * @return The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the
     *         policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.
     */
    public final FirewallPolicyResponse firewallPolicyResponse() {
        return firewallPolicyResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallPolicyResponse)) {
            return false;
        }
        CreateFirewallPolicyResponse other = (CreateFirewallPolicyResponse) obj;
        return Objects.equals(updateToken(), other.updateToken())
                && Objects.equals(firewallPolicyResponse(), other.firewallPolicyResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFirewallPolicyResponse").add("UpdateToken", updateToken())
                .add("FirewallPolicyResponse", firewallPolicyResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "FirewallPolicyResponse":
            return Optional.ofNullable(clazz.cast(firewallPolicyResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallPolicyResponse, T> g) {
        return obj -> g.apply((CreateFirewallPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFirewallPolicyResponse> {
        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         * firewall policy. The token marks the state of the policy resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the policy, you provide the token in your request. Network Firewall uses the token to
         * ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a
         * current copy of it with current token. Reapply your changes as needed, then try the operation again using the
         * new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        firewall policy. The token marks the state of the policy resource at the time of the request. </p>
         *        <p>
         *        To make changes to the policy, you provide the token in your request. Network Firewall uses the token
         *        to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation
         *        fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again
         *        to get a current copy of it with current token. Reapply your changes as needed, then try the operation
         *        again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the
         * policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.
         * </p>
         * 
         * @param firewallPolicyResponse
         *        The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the
         *        policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyResponse(FirewallPolicyResponse firewallPolicyResponse);

        /**
         * <p>
         * The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the
         * policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallPolicyResponse.Builder} avoiding the
         * need to create one manually via {@link FirewallPolicyResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallPolicyResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #firewallPolicyResponse(FirewallPolicyResponse)}.
         * 
         * @param firewallPolicyResponse
         *        a consumer that will call methods on {@link FirewallPolicyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallPolicyResponse(FirewallPolicyResponse)
         */
        default Builder firewallPolicyResponse(Consumer<FirewallPolicyResponse.Builder> firewallPolicyResponse) {
            return firewallPolicyResponse(FirewallPolicyResponse.builder().applyMutation(firewallPolicyResponse).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String updateToken;

        private FirewallPolicyResponse firewallPolicyResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallPolicyResponse model) {
            super(model);
            updateToken(model.updateToken);
            firewallPolicyResponse(model.firewallPolicyResponse);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        @Transient
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final FirewallPolicyResponse.Builder getFirewallPolicyResponse() {
            return firewallPolicyResponse != null ? firewallPolicyResponse.toBuilder() : null;
        }

        public final void setFirewallPolicyResponse(FirewallPolicyResponse.BuilderImpl firewallPolicyResponse) {
            this.firewallPolicyResponse = firewallPolicyResponse != null ? firewallPolicyResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder firewallPolicyResponse(FirewallPolicyResponse firewallPolicyResponse) {
            this.firewallPolicyResponse = firewallPolicyResponse;
            return this;
        }

        @Override
        public CreateFirewallPolicyResponse build() {
            return new CreateFirewallPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
