/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFirewallResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<CreateFirewallResponse.Builder, CreateFirewallResponse> {
    private static final SdkField<Firewall> FIREWALL_FIELD = SdkField.<Firewall> builder(MarshallingType.SDK_POJO)
            .memberName("Firewall").getter(getter(CreateFirewallResponse::firewall)).setter(setter(Builder::firewall))
            .constructor(Firewall::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Firewall").build()).build();

    private static final SdkField<FirewallStatus> FIREWALL_STATUS_FIELD = SdkField
            .<FirewallStatus> builder(MarshallingType.SDK_POJO).memberName("FirewallStatus")
            .getter(getter(CreateFirewallResponse::firewallStatus)).setter(setter(Builder::firewallStatus))
            .constructor(FirewallStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_FIELD,
            FIREWALL_STATUS_FIELD));

    private final Firewall firewall;

    private final FirewallStatus firewallStatus;

    private CreateFirewallResponse(BuilderImpl builder) {
        super(builder);
        this.firewall = builder.firewall;
        this.firewallStatus = builder.firewallStatus;
    }

    /**
     * <p>
     * The configuration settings for the firewall. These settings include the firewall policy and the subnets in your
     * VPC to use for the firewall endpoints.
     * </p>
     * 
     * @return The configuration settings for the firewall. These settings include the firewall policy and the subnets
     *         in your VPC to use for the firewall endpoints.
     */
    public final Firewall firewall() {
        return firewall;
    }

    /**
     * <p>
     * Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by
     * calling <a>DescribeFirewall</a> and providing the firewall name and ARN.
     * </p>
     * 
     * @return Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall
     *         by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.
     */
    public final FirewallStatus firewallStatus() {
        return firewallStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewall());
        hashCode = 31 * hashCode + Objects.hashCode(firewallStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallResponse)) {
            return false;
        }
        CreateFirewallResponse other = (CreateFirewallResponse) obj;
        return Objects.equals(firewall(), other.firewall()) && Objects.equals(firewallStatus(), other.firewallStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFirewallResponse").add("Firewall", firewall()).add("FirewallStatus", firewallStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Firewall":
            return Optional.ofNullable(clazz.cast(firewall()));
        case "FirewallStatus":
            return Optional.ofNullable(clazz.cast(firewallStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallResponse, T> g) {
        return obj -> g.apply((CreateFirewallResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFirewallResponse> {
        /**
         * <p>
         * The configuration settings for the firewall. These settings include the firewall policy and the subnets in
         * your VPC to use for the firewall endpoints.
         * </p>
         * 
         * @param firewall
         *        The configuration settings for the firewall. These settings include the firewall policy and the
         *        subnets in your VPC to use for the firewall endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewall(Firewall firewall);

        /**
         * <p>
         * The configuration settings for the firewall. These settings include the firewall policy and the subnets in
         * your VPC to use for the firewall endpoints.
         * </p>
         * This is a convenience that creates an instance of the {@link Firewall.Builder} avoiding the need to create
         * one manually via {@link Firewall#builder()}.
         *
         * When the {@link Consumer} completes, {@link Firewall.Builder#build()} is called immediately and its result is
         * passed to {@link #firewall(Firewall)}.
         * 
         * @param firewall
         *        a consumer that will call methods on {@link Firewall.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewall(Firewall)
         */
        default Builder firewall(Consumer<Firewall.Builder> firewall) {
            return firewall(Firewall.builder().applyMutation(firewall).build());
        }

        /**
         * <p>
         * Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by
         * calling <a>DescribeFirewall</a> and providing the firewall name and ARN.
         * </p>
         * 
         * @param firewallStatus
         *        Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a
         *        firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallStatus(FirewallStatus firewallStatus);

        /**
         * <p>
         * Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by
         * calling <a>DescribeFirewall</a> and providing the firewall name and ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallStatus.Builder} avoiding the need to
         * create one manually via {@link FirewallStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #firewallStatus(FirewallStatus)}.
         * 
         * @param firewallStatus
         *        a consumer that will call methods on {@link FirewallStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallStatus(FirewallStatus)
         */
        default Builder firewallStatus(Consumer<FirewallStatus.Builder> firewallStatus) {
            return firewallStatus(FirewallStatus.builder().applyMutation(firewallStatus).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private Firewall firewall;

        private FirewallStatus firewallStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallResponse model) {
            super(model);
            firewall(model.firewall);
            firewallStatus(model.firewallStatus);
        }

        public final Firewall.Builder getFirewall() {
            return firewall != null ? firewall.toBuilder() : null;
        }

        public final void setFirewall(Firewall.BuilderImpl firewall) {
            this.firewall = firewall != null ? firewall.build() : null;
        }

        @Override
        @Transient
        public final Builder firewall(Firewall firewall) {
            this.firewall = firewall;
            return this;
        }

        public final FirewallStatus.Builder getFirewallStatus() {
            return firewallStatus != null ? firewallStatus.toBuilder() : null;
        }

        public final void setFirewallStatus(FirewallStatus.BuilderImpl firewallStatus) {
            this.firewallStatus = firewallStatus != null ? firewallStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder firewallStatus(FirewallStatus firewallStatus) {
            this.firewallStatus = firewallStatus;
            return this;
        }

        @Override
        public CreateFirewallResponse build() {
            return new CreateFirewallResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
