/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional, non-standard action to use for stateless packet handling. You can define this in addition to the
 * standard action that you must specify.
 * </p>
 * <p>
 * You define and name the custom actions that you want to be able to use, and then you reference them by name in your
 * actions settings.
 * </p>
 * <p>
 * You can use custom actions in the following places:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In a rule group's <a>StatelessRulesAndCustomActions</a> specification. The custom actions are available for use by
 * name inside the <code>StatelessRulesAndCustomActions</code> where you define them. You can use them for your
 * stateless rule actions to specify what to do with a packet that matches the rule's match attributes.
 * </p>
 * </li>
 * <li>
 * <p>
 * In a <a>FirewallPolicy</a> specification, in <code>StatelessCustomActions</code>. The custom actions are available
 * for use inside the policy where you define them. You can use them for the policy's default stateless actions settings
 * to specify what to do with packets that don't match any of the policy's stateless rules.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAction implements SdkPojo, Serializable, ToCopyableBuilder<CustomAction.Builder, CustomAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(CustomAction::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final SdkField<ActionDefinition> ACTION_DEFINITION_FIELD = SdkField
            .<ActionDefinition> builder(MarshallingType.SDK_POJO).memberName("ActionDefinition")
            .getter(getter(CustomAction::actionDefinition)).setter(setter(Builder::actionDefinition))
            .constructor(ActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            ACTION_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final ActionDefinition actionDefinition;

    private CustomAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.actionDefinition = builder.actionDefinition;
    }

    /**
     * <p>
     * The descriptive name of the custom action. You can't change the name of a custom action after you create it.
     * </p>
     * 
     * @return The descriptive name of the custom action. You can't change the name of a custom action after you create
     *         it.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The custom action associated with the action name.
     * </p>
     * 
     * @return The custom action associated with the action name.
     */
    public final ActionDefinition actionDefinition() {
        return actionDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAction)) {
            return false;
        }
        CustomAction other = (CustomAction) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(actionDefinition(), other.actionDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomAction").add("ActionName", actionName()).add("ActionDefinition", actionDefinition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "ActionDefinition":
            return Optional.ofNullable(clazz.cast(actionDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomAction, T> g) {
        return obj -> g.apply((CustomAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAction> {
        /**
         * <p>
         * The descriptive name of the custom action. You can't change the name of a custom action after you create it.
         * </p>
         * 
         * @param actionName
         *        The descriptive name of the custom action. You can't change the name of a custom action after you
         *        create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The custom action associated with the action name.
         * </p>
         * 
         * @param actionDefinition
         *        The custom action associated with the action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinition(ActionDefinition actionDefinition);

        /**
         * <p>
         * The custom action associated with the action name.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionDefinition.Builder} avoiding the need to
         * create one manually via {@link ActionDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #actionDefinition(ActionDefinition)}.
         * 
         * @param actionDefinition
         *        a consumer that will call methods on {@link ActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionDefinition(ActionDefinition)
         */
        default Builder actionDefinition(Consumer<ActionDefinition.Builder> actionDefinition) {
            return actionDefinition(ActionDefinition.builder().applyMutation(actionDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private ActionDefinition actionDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAction model) {
            actionName(model.actionName);
            actionDefinition(model.actionDefinition);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        @Transient
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final ActionDefinition.Builder getActionDefinition() {
            return actionDefinition != null ? actionDefinition.toBuilder() : null;
        }

        public final void setActionDefinition(ActionDefinition.BuilderImpl actionDefinition) {
            this.actionDefinition = actionDefinition != null ? actionDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder actionDefinition(ActionDefinition actionDefinition) {
            this.actionDefinition = actionDefinition;
            return this;
        }

        @Override
        public CustomAction build() {
            return new CustomAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
