/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallPolicyResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DeleteFirewallPolicyResponse.Builder, DeleteFirewallPolicyResponse> {
    private static final SdkField<FirewallPolicyResponse> FIREWALL_POLICY_RESPONSE_FIELD = SdkField
            .<FirewallPolicyResponse> builder(MarshallingType.SDK_POJO).memberName("FirewallPolicyResponse")
            .getter(getter(DeleteFirewallPolicyResponse::firewallPolicyResponse)).setter(setter(Builder::firewallPolicyResponse))
            .constructor(FirewallPolicyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyResponse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIREWALL_POLICY_RESPONSE_FIELD));

    private final FirewallPolicyResponse firewallPolicyResponse;

    private DeleteFirewallPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.firewallPolicyResponse = builder.firewallPolicyResponse;
    }

    /**
     * <p>
     * The object containing the definition of the <a>FirewallPolicyResponse</a> that you asked to delete.
     * </p>
     * 
     * @return The object containing the definition of the <a>FirewallPolicyResponse</a> that you asked to delete.
     */
    public final FirewallPolicyResponse firewallPolicyResponse() {
        return firewallPolicyResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallPolicyResponse)) {
            return false;
        }
        DeleteFirewallPolicyResponse other = (DeleteFirewallPolicyResponse) obj;
        return Objects.equals(firewallPolicyResponse(), other.firewallPolicyResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFirewallPolicyResponse").add("FirewallPolicyResponse", firewallPolicyResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallPolicyResponse":
            return Optional.ofNullable(clazz.cast(firewallPolicyResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallPolicyResponse, T> g) {
        return obj -> g.apply((DeleteFirewallPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteFirewallPolicyResponse> {
        /**
         * <p>
         * The object containing the definition of the <a>FirewallPolicyResponse</a> that you asked to delete.
         * </p>
         * 
         * @param firewallPolicyResponse
         *        The object containing the definition of the <a>FirewallPolicyResponse</a> that you asked to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyResponse(FirewallPolicyResponse firewallPolicyResponse);

        /**
         * <p>
         * The object containing the definition of the <a>FirewallPolicyResponse</a> that you asked to delete.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallPolicyResponse.Builder} avoiding the
         * need to create one manually via {@link FirewallPolicyResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallPolicyResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #firewallPolicyResponse(FirewallPolicyResponse)}.
         * 
         * @param firewallPolicyResponse
         *        a consumer that will call methods on {@link FirewallPolicyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallPolicyResponse(FirewallPolicyResponse)
         */
        default Builder firewallPolicyResponse(Consumer<FirewallPolicyResponse.Builder> firewallPolicyResponse) {
            return firewallPolicyResponse(FirewallPolicyResponse.builder().applyMutation(firewallPolicyResponse).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private FirewallPolicyResponse firewallPolicyResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallPolicyResponse model) {
            super(model);
            firewallPolicyResponse(model.firewallPolicyResponse);
        }

        public final FirewallPolicyResponse.Builder getFirewallPolicyResponse() {
            return firewallPolicyResponse != null ? firewallPolicyResponse.toBuilder() : null;
        }

        public final void setFirewallPolicyResponse(FirewallPolicyResponse.BuilderImpl firewallPolicyResponse) {
            this.firewallPolicyResponse = firewallPolicyResponse != null ? firewallPolicyResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder firewallPolicyResponse(FirewallPolicyResponse firewallPolicyResponse) {
            this.firewallPolicyResponse = firewallPolicyResponse;
            return this;
        }

        @Override
        public DeleteFirewallPolicyResponse build() {
            return new DeleteFirewallPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
