/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling
 * <a>DescribeFirewall</a> and providing the firewall name and ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallStatus implements SdkPojo, Serializable, ToCopyableBuilder<FirewallStatus.Builder, FirewallStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FirewallStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CONFIGURATION_SYNC_STATE_SUMMARY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSyncStateSummary")
            .getter(getter(FirewallStatus::configurationSyncStateSummaryAsString))
            .setter(setter(Builder::configurationSyncStateSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSyncStateSummary")
                    .build()).build();

    private static final SdkField<Map<String, SyncState>> SYNC_STATES_FIELD = SdkField
            .<Map<String, SyncState>> builder(MarshallingType.MAP)
            .memberName("SyncStates")
            .getter(getter(FirewallStatus::syncStates))
            .setter(setter(Builder::syncStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncStates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SyncState> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyncState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CONFIGURATION_SYNC_STATE_SUMMARY_FIELD, SYNC_STATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String configurationSyncStateSummary;

    private final Map<String, SyncState> syncStates;

    private FirewallStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.configurationSyncStateSummary = builder.configurationSyncStateSummary;
        this.syncStates = builder.syncStates;
    }

    /**
     * <p>
     * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where
     * you've configured it. This setting is <code>READY</code> only when the <code>ConfigurationSyncStateSummary</code>
     * value is <code>IN_SYNC</code> and the <code>Attachment</code> <code>Status</code> values for all of the
     * configured subnets are <code>READY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The readiness of the configured firewall to handle network traffic across all of the Availability Zones
     *         where you've configured it. This setting is <code>READY</code> only when the
     *         <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
     *         <code>Status</code> values for all of the configured subnets are <code>READY</code>.
     * @see FirewallStatusValue
     */
    public final FirewallStatusValue status() {
        return FirewallStatusValue.fromValue(status);
    }

    /**
     * <p>
     * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where
     * you've configured it. This setting is <code>READY</code> only when the <code>ConfigurationSyncStateSummary</code>
     * value is <code>IN_SYNC</code> and the <code>Attachment</code> <code>Status</code> values for all of the
     * configured subnets are <code>READY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The readiness of the configured firewall to handle network traffic across all of the Availability Zones
     *         where you've configured it. This setting is <code>READY</code> only when the
     *         <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
     *         <code>Status</code> values for all of the configured subnets are <code>READY</code>.
     * @see FirewallStatusValue
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The configuration sync state for the firewall. This summarizes the sync states reported in the
     * <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
     * </p>
     * <p>
     * When you create a firewall or update its configuration, for example by adding a rule group to its firewall
     * policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This
     * summary indicates whether the configuration changes have been applied everywhere.
     * </p>
     * <p>
     * This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate that the
     * firewall is ready. The <code>Status</code> setting indicates firewall readiness.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationSyncStateSummary} will return {@link ConfigurationSyncState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #configurationSyncStateSummaryAsString}.
     * </p>
     * 
     * @return The configuration sync state for the firewall. This summarizes the sync states reported in the
     *         <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
     *         </p>
     *         <p>
     *         When you create a firewall or update its configuration, for example by adding a rule group to its
     *         firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall
     *         is in use. This summary indicates whether the configuration changes have been applied everywhere.
     *         </p>
     *         <p>
     *         This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate
     *         that the firewall is ready. The <code>Status</code> setting indicates firewall readiness.
     * @see ConfigurationSyncState
     */
    public final ConfigurationSyncState configurationSyncStateSummary() {
        return ConfigurationSyncState.fromValue(configurationSyncStateSummary);
    }

    /**
     * <p>
     * The configuration sync state for the firewall. This summarizes the sync states reported in the
     * <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
     * </p>
     * <p>
     * When you create a firewall or update its configuration, for example by adding a rule group to its firewall
     * policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This
     * summary indicates whether the configuration changes have been applied everywhere.
     * </p>
     * <p>
     * This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate that the
     * firewall is ready. The <code>Status</code> setting indicates firewall readiness.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationSyncStateSummary} will return {@link ConfigurationSyncState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #configurationSyncStateSummaryAsString}.
     * </p>
     * 
     * @return The configuration sync state for the firewall. This summarizes the sync states reported in the
     *         <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
     *         </p>
     *         <p>
     *         When you create a firewall or update its configuration, for example by adding a rule group to its
     *         firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall
     *         is in use. This summary indicates whether the configuration changes have been applied everywhere.
     *         </p>
     *         <p>
     *         This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate
     *         that the firewall is ready. The <code>Status</code> setting indicates firewall readiness.
     * @see ConfigurationSyncState
     */
    public final String configurationSyncStateSummaryAsString() {
        return configurationSyncStateSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the SyncStates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSyncStates() {
        return syncStates != null && !(syncStates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The subnets that you've configured for use by the Network Firewall firewall. This contains one array element per
     * Availability Zone where you've configured a subnet. These objects provide details of the information that is
     * summarized in the <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone and
     * configuration object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSyncStates} method.
     * </p>
     * 
     * @return The subnets that you've configured for use by the Network Firewall firewall. This contains one array
     *         element per Availability Zone where you've configured a subnet. These objects provide details of the
     *         information that is summarized in the <code>ConfigurationSyncStateSummary</code> and <code>Status</code>,
     *         broken down by zone and configuration object.
     */
    public final Map<String, SyncState> syncStates() {
        return syncStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSyncStateSummaryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSyncStates() ? syncStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatus)) {
            return false;
        }
        FirewallStatus other = (FirewallStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(configurationSyncStateSummaryAsString(), other.configurationSyncStateSummaryAsString())
                && hasSyncStates() == other.hasSyncStates() && Objects.equals(syncStates(), other.syncStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallStatus").add("Status", statusAsString())
                .add("ConfigurationSyncStateSummary", configurationSyncStateSummaryAsString())
                .add("SyncStates", hasSyncStates() ? syncStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ConfigurationSyncStateSummary":
            return Optional.ofNullable(clazz.cast(configurationSyncStateSummaryAsString()));
        case "SyncStates":
            return Optional.ofNullable(clazz.cast(syncStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallStatus, T> g) {
        return obj -> g.apply((FirewallStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallStatus> {
        /**
         * <p>
         * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where
         * you've configured it. This setting is <code>READY</code> only when the
         * <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
         * <code>Status</code> values for all of the configured subnets are <code>READY</code>.
         * </p>
         * 
         * @param status
         *        The readiness of the configured firewall to handle network traffic across all of the Availability
         *        Zones where you've configured it. This setting is <code>READY</code> only when the
         *        <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
         *        <code>Attachment</code> <code>Status</code> values for all of the configured subnets are
         *        <code>READY</code>.
         * @see FirewallStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallStatusValue
         */
        Builder status(String status);

        /**
         * <p>
         * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where
         * you've configured it. This setting is <code>READY</code> only when the
         * <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
         * <code>Status</code> values for all of the configured subnets are <code>READY</code>.
         * </p>
         * 
         * @param status
         *        The readiness of the configured firewall to handle network traffic across all of the Availability
         *        Zones where you've configured it. This setting is <code>READY</code> only when the
         *        <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
         *        <code>Attachment</code> <code>Status</code> values for all of the configured subnets are
         *        <code>READY</code>.
         * @see FirewallStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallStatusValue
         */
        Builder status(FirewallStatusValue status);

        /**
         * <p>
         * The configuration sync state for the firewall. This summarizes the sync states reported in the
         * <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
         * </p>
         * <p>
         * When you create a firewall or update its configuration, for example by adding a rule group to its firewall
         * policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use.
         * This summary indicates whether the configuration changes have been applied everywhere.
         * </p>
         * <p>
         * This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate that
         * the firewall is ready. The <code>Status</code> setting indicates firewall readiness.
         * </p>
         * 
         * @param configurationSyncStateSummary
         *        The configuration sync state for the firewall. This summarizes the sync states reported in the
         *        <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
         *        </p>
         *        <p>
         *        When you create a firewall or update its configuration, for example by adding a rule group to its
         *        firewall policy, Network Firewall distributes the configuration changes to all zones where the
         *        firewall is in use. This summary indicates whether the configuration changes have been applied
         *        everywhere.
         *        </p>
         *        <p>
         *        This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate
         *        that the firewall is ready. The <code>Status</code> setting indicates firewall readiness.
         * @see ConfigurationSyncState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSyncState
         */
        Builder configurationSyncStateSummary(String configurationSyncStateSummary);

        /**
         * <p>
         * The configuration sync state for the firewall. This summarizes the sync states reported in the
         * <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
         * </p>
         * <p>
         * When you create a firewall or update its configuration, for example by adding a rule group to its firewall
         * policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use.
         * This summary indicates whether the configuration changes have been applied everywhere.
         * </p>
         * <p>
         * This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate that
         * the firewall is ready. The <code>Status</code> setting indicates firewall readiness.
         * </p>
         * 
         * @param configurationSyncStateSummary
         *        The configuration sync state for the firewall. This summarizes the sync states reported in the
         *        <code>Config</code> settings for all of the Availability Zones where you have configured the firewall.
         *        </p>
         *        <p>
         *        When you create a firewall or update its configuration, for example by adding a rule group to its
         *        firewall policy, Network Firewall distributes the configuration changes to all zones where the
         *        firewall is in use. This summary indicates whether the configuration changes have been applied
         *        everywhere.
         *        </p>
         *        <p>
         *        This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn't indicate
         *        that the firewall is ready. The <code>Status</code> setting indicates firewall readiness.
         * @see ConfigurationSyncState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSyncState
         */
        Builder configurationSyncStateSummary(ConfigurationSyncState configurationSyncStateSummary);

        /**
         * <p>
         * The subnets that you've configured for use by the Network Firewall firewall. This contains one array element
         * per Availability Zone where you've configured a subnet. These objects provide details of the information that
         * is summarized in the <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone
         * and configuration object.
         * </p>
         * 
         * @param syncStates
         *        The subnets that you've configured for use by the Network Firewall firewall. This contains one array
         *        element per Availability Zone where you've configured a subnet. These objects provide details of the
         *        information that is summarized in the <code>ConfigurationSyncStateSummary</code> and
         *        <code>Status</code>, broken down by zone and configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncStates(Map<String, SyncState> syncStates);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String configurationSyncStateSummary;

        private Map<String, SyncState> syncStates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallStatus model) {
            status(model.status);
            configurationSyncStateSummary(model.configurationSyncStateSummary);
            syncStates(model.syncStates);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(FirewallStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConfigurationSyncStateSummary() {
            return configurationSyncStateSummary;
        }

        public final void setConfigurationSyncStateSummary(String configurationSyncStateSummary) {
            this.configurationSyncStateSummary = configurationSyncStateSummary;
        }

        @Override
        @Transient
        public final Builder configurationSyncStateSummary(String configurationSyncStateSummary) {
            this.configurationSyncStateSummary = configurationSyncStateSummary;
            return this;
        }

        @Override
        @Transient
        public final Builder configurationSyncStateSummary(ConfigurationSyncState configurationSyncStateSummary) {
            this.configurationSyncStateSummary(configurationSyncStateSummary == null ? null : configurationSyncStateSummary
                    .toString());
            return this;
        }

        public final Map<String, SyncState.Builder> getSyncStates() {
            Map<String, SyncState.Builder> result = SyncStatesCopier.copyToBuilder(this.syncStates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSyncStates(Map<String, SyncState.BuilderImpl> syncStates) {
            this.syncStates = SyncStatesCopier.copyFromBuilder(syncStates);
        }

        @Override
        @Transient
        public final Builder syncStates(Map<String, SyncState> syncStates) {
            this.syncStates = SyncStatesCopier.copy(syncStates);
            return this;
        }

        @Override
        public FirewallStatus build() {
            return new FirewallStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
