/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallsRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<ListFirewallsRequest.Builder, ListFirewallsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> VPC_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcIds")
            .getter(getter(ListFirewallsRequest::vpcIds))
            .setter(setter(Builder::vpcIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFirewallsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VPC_IDS_FIELD, MAX_RESULTS_FIELD));

    private final String nextToken;

    private final List<String> vpcIds;

    private final Integer maxResults;

    private ListFirewallsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vpcIds = builder.vpcIds;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVpcIds() {
        return vpcIds != null && !(vpcIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank
     * to retrieve all firewalls that you have defined.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcIds} method.
     * </p>
     * 
     * @return The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave
     *         this blank to retrieve all firewalls that you have defined.
     */
    public final List<String> vpcIds() {
        return vpcIds;
    }

    /**
     * <p>
     * The maximum number of objects that you want Network Firewall to return for this request. If more objects are
     * available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a
     * subsequent call to get the next batch of objects.
     * </p>
     * 
     * @return The maximum number of objects that you want Network Firewall to return for this request. If more objects
     *         are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use
     *         in a subsequent call to get the next batch of objects.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcIds() ? vpcIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallsRequest)) {
            return false;
        }
        ListFirewallsRequest other = (ListFirewallsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVpcIds() == other.hasVpcIds()
                && Objects.equals(vpcIds(), other.vpcIds()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallsRequest").add("NextToken", nextToken())
                .add("VpcIds", hasVpcIds() ? vpcIds() : null).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VpcIds":
            return Optional.ofNullable(clazz.cast(vpcIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallsRequest, T> g) {
        return obj -> g.apply((ListFirewallsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFirewallsRequest> {
        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this
         * blank to retrieve all firewalls that you have defined.
         * </p>
         * 
         * @param vpcIds
         *        The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave
         *        this blank to retrieve all firewalls that you have defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIds(Collection<String> vpcIds);

        /**
         * <p>
         * The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this
         * blank to retrieve all firewalls that you have defined.
         * </p>
         * 
         * @param vpcIds
         *        The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave
         *        this blank to retrieve all firewalls that you have defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIds(String... vpcIds);

        /**
         * <p>
         * The maximum number of objects that you want Network Firewall to return for this request. If more objects are
         * available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a
         * subsequent call to get the next batch of objects.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that you want Network Firewall to return for this request. If more
         *        objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that
         *        you can use in a subsequent call to get the next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> vpcIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallsRequest model) {
            super(model);
            nextToken(model.nextToken);
            vpcIds(model.vpcIds);
            maxResults(model.maxResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getVpcIds() {
            if (vpcIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcIds;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcIdsCopier.copy(vpcIds);
        }

        @Override
        @Transient
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcIdsCopier.copy(vpcIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcIds(String... vpcIds) {
            vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFirewallsRequest build() {
            return new ListFirewallsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
