/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifier for a single stateless rule group, used in a firewall policy to refer to the rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatelessRuleGroupReference implements SdkPojo, Serializable,
        ToCopyableBuilder<StatelessRuleGroupReference.Builder, StatelessRuleGroupReference> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(StatelessRuleGroupReference::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(StatelessRuleGroupReference::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final Integer priority;

    private StatelessRuleGroupReference(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stateless rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stateless rule group.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * An integer setting that indicates the order in which to run the stateless rule groups in a single
     * <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group to a packet starting with the group
     * that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
     * </p>
     * 
     * @return An integer setting that indicates the order in which to run the stateless rule groups in a single
     *         <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group to a packet starting with the
     *         group that has the lowest priority setting. You must ensure that the priority settings are unique within
     *         each policy.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatelessRuleGroupReference)) {
            return false;
        }
        StatelessRuleGroupReference other = (StatelessRuleGroupReference) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatelessRuleGroupReference").add("ResourceArn", resourceArn()).add("Priority", priority())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatelessRuleGroupReference, T> g) {
        return obj -> g.apply((StatelessRuleGroupReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatelessRuleGroupReference> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stateless rule group.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An integer setting that indicates the order in which to run the stateless rule groups in a single
         * <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group to a packet starting with the group
         * that has the lowest priority setting. You must ensure that the priority settings are unique within each
         * policy.
         * </p>
         * 
         * @param priority
         *        An integer setting that indicates the order in which to run the stateless rule groups in a single
         *        <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group to a packet starting with
         *        the group that has the lowest priority setting. You must ensure that the priority settings are unique
         *        within each policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(StatelessRuleGroupReference model) {
            resourceArn(model.resourceArn);
            priority(model.priority);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public StatelessRuleGroupReference build() {
            return new StatelessRuleGroupReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
