/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFirewallPolicyRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateFirewallPolicyRequest.Builder, UpdateFirewallPolicyRequest> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateFirewallPolicyRequest::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyArn").getter(getter(UpdateFirewallPolicyRequest::firewallPolicyArn))
            .setter(setter(Builder::firewallPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyName").getter(getter(UpdateFirewallPolicyRequest::firewallPolicyName))
            .setter(setter(Builder::firewallPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build())
            .build();

    private static final SdkField<FirewallPolicy> FIREWALL_POLICY_FIELD = SdkField
            .<FirewallPolicy> builder(MarshallingType.SDK_POJO).memberName("FirewallPolicy")
            .getter(getter(UpdateFirewallPolicyRequest::firewallPolicy)).setter(setter(Builder::firewallPolicy))
            .constructor(FirewallPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFirewallPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(UpdateFirewallPolicyRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD,
            FIREWALL_POLICY_ARN_FIELD, FIREWALL_POLICY_NAME_FIELD, FIREWALL_POLICY_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD));

    private final String updateToken;

    private final String firewallPolicyArn;

    private final String firewallPolicyName;

    private final FirewallPolicy firewallPolicy;

    private final String description;

    private final Boolean dryRun;

    private UpdateFirewallPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicy = builder.firewallPolicy;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall
     * policy. The token marks the state of the policy resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure
     * that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an
     * <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of
     * it with current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         firewall policy. The token marks the state of the policy resource at the time of the request. </p>
     *         <p>
     *         To make changes to the policy, you provide the token in your request. Network Firewall uses the token to
     *         ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails
     *         with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a
     *         current copy of it with current token. Reapply your changes as needed, then try the operation again using
     *         the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall policy.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall policy.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String firewallPolicyArn() {
        return firewallPolicyArn;
    }

    /**
     * <p>
     * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the firewall policy. You can't change the name of a firewall policy after you
     *         create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String firewallPolicyName() {
        return firewallPolicyName;
    }

    /**
     * <p>
     * The updated firewall policy to use for the firewall.
     * </p>
     * 
     * @return The updated firewall policy to use for the firewall.
     */
    public final FirewallPolicy firewallPolicy() {
        return firewallPolicy;
    }

    /**
     * <p>
     * A description of the firewall policy.
     * </p>
     * 
     * @return A description of the firewall policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
     * request.
     * </p>
     * <p>
     * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
     * actually make the requested changes. The call returns the value that the request would return if you ran it with
     * dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows
     * you to make sure that you have the required permissions to run the request and that your request parameters are
     * valid.
     * </p>
     * <p>
     * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     * </p>
     * 
     * @return Indicates whether you want Network Firewall to just check the validity of the request, rather than run
     *         the request. </p>
     *         <p>
     *         If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
     *         doesn't actually make the requested changes. The call returns the value that the request would return if
     *         you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
     *         resources. This option allows you to make sure that you have the required permissions to run the request
     *         and that your request parameters are valid.
     *         </p>
     *         <p>
     *         If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallPolicyRequest)) {
            return false;
        }
        UpdateFirewallPolicyRequest other = (UpdateFirewallPolicyRequest) obj;
        return Objects.equals(updateToken(), other.updateToken())
                && Objects.equals(firewallPolicyArn(), other.firewallPolicyArn())
                && Objects.equals(firewallPolicyName(), other.firewallPolicyName())
                && Objects.equals(firewallPolicy(), other.firewallPolicy()) && Objects.equals(description(), other.description())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFirewallPolicyRequest").add("UpdateToken", updateToken())
                .add("FirewallPolicyArn", firewallPolicyArn()).add("FirewallPolicyName", firewallPolicyName())
                .add("FirewallPolicy", firewallPolicy()).add("Description", description()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "FirewallPolicyArn":
            return Optional.ofNullable(clazz.cast(firewallPolicyArn()));
        case "FirewallPolicyName":
            return Optional.ofNullable(clazz.cast(firewallPolicyName()));
        case "FirewallPolicy":
            return Optional.ofNullable(clazz.cast(firewallPolicy()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallPolicyRequest, T> g) {
        return obj -> g.apply((UpdateFirewallPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFirewallPolicyRequest> {
        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         * firewall policy. The token marks the state of the policy resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the policy, you provide the token in your request. Network Firewall uses the token to
         * ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a
         * current copy of it with current token. Reapply your changes as needed, then try the operation again using the
         * new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        firewall policy. The token marks the state of the policy resource at the time of the request. </p>
         *        <p>
         *        To make changes to the policy, you provide the token in your request. Network Firewall uses the token
         *        to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation
         *        fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again
         *        to get a current copy of it with current token. Reapply your changes as needed, then try the operation
         *        again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall policy.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param firewallPolicyArn
         *        The Amazon Resource Name (ARN) of the firewall policy.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyArn(String firewallPolicyArn);

        /**
         * <p>
         * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create
         * it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param firewallPolicyName
         *        The descriptive name of the firewall policy. You can't change the name of a firewall policy after you
         *        create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyName(String firewallPolicyName);

        /**
         * <p>
         * The updated firewall policy to use for the firewall.
         * </p>
         * 
         * @param firewallPolicy
         *        The updated firewall policy to use for the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicy(FirewallPolicy firewallPolicy);

        /**
         * <p>
         * The updated firewall policy to use for the firewall.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallPolicy.Builder} avoiding the need to
         * create one manually via {@link FirewallPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #firewallPolicy(FirewallPolicy)}.
         * 
         * @param firewallPolicy
         *        a consumer that will call methods on {@link FirewallPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallPolicy(FirewallPolicy)
         */
        default Builder firewallPolicy(Consumer<FirewallPolicy.Builder> firewallPolicy) {
            return firewallPolicy(FirewallPolicy.builder().applyMutation(firewallPolicy).build());
        }

        /**
         * <p>
         * A description of the firewall policy.
         * </p>
         * 
         * @param description
         *        A description of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
         * request.
         * </p>
         * <p>
         * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
         * actually make the requested changes. The call returns the value that the request would return if you ran it
         * with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option
         * allows you to make sure that you have the required permissions to run the request and that your request
         * parameters are valid.
         * </p>
         * <p>
         * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * </p>
         * 
         * @param dryRun
         *        Indicates whether you want Network Firewall to just check the validity of the request, rather than run
         *        the request. </p>
         *        <p>
         *        If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
         *        doesn't actually make the requested changes. The call returns the value that the request would return
         *        if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
         *        resources. This option allows you to make sure that you have the required permissions to run the
         *        request and that your request parameters are valid.
         *        </p>
         *        <p>
         *        If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String updateToken;

        private String firewallPolicyArn;

        private String firewallPolicyName;

        private FirewallPolicy firewallPolicy;

        private String description;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallPolicyRequest model) {
            super(model);
            updateToken(model.updateToken);
            firewallPolicyArn(model.firewallPolicyArn);
            firewallPolicyName(model.firewallPolicyName);
            firewallPolicy(model.firewallPolicy);
            description(model.description);
            dryRun(model.dryRun);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        @Transient
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        @Transient
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getFirewallPolicyName() {
            return firewallPolicyName;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        @Override
        @Transient
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final FirewallPolicy.Builder getFirewallPolicy() {
            return firewallPolicy != null ? firewallPolicy.toBuilder() : null;
        }

        public final void setFirewallPolicy(FirewallPolicy.BuilderImpl firewallPolicy) {
            this.firewallPolicy = firewallPolicy != null ? firewallPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder firewallPolicy(FirewallPolicy firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        @Transient
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallPolicyRequest build() {
            return new UpdateFirewallPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
