/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleGroupRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateRuleGroupRequest.Builder, UpdateRuleGroupRequest> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateRuleGroupRequest::updateToken)).setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn").getter(getter(UpdateRuleGroupRequest::ruleGroupArn))
            .setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()).build();

    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupName").getter(getter(UpdateRuleGroupRequest::ruleGroupName))
            .setter(setter(Builder::ruleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()).build();

    private static final SdkField<RuleGroup> RULE_GROUP_FIELD = SdkField.<RuleGroup> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroup").getter(getter(UpdateRuleGroupRequest::ruleGroup)).setter(setter(Builder::ruleGroup))
            .constructor(RuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()).build();

    private static final SdkField<String> RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rules")
            .getter(getter(UpdateRuleGroupRequest::rules)).setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateRuleGroupRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateRuleGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(UpdateRuleGroupRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD,
            RULE_GROUP_ARN_FIELD, RULE_GROUP_NAME_FIELD, RULE_GROUP_FIELD, RULES_FIELD, TYPE_FIELD, DESCRIPTION_FIELD,
            DRY_RUN_FIELD));

    private final String updateToken;

    private final String ruleGroupArn;

    private final String ruleGroupName;

    private final RuleGroup ruleGroup;

    private final String rules;

    private final String type;

    private final String description;

    private final Boolean dryRun;

    private UpdateRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroup = builder.ruleGroup;
        this.rules = builder.rules;
        this.type = builder.type;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule
     * group. The token marks the state of the rule group resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to
     * ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails
     * with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy
     * of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         rule group. The token marks the state of the rule group resource at the time of the request. </p>
     *         <p>
     *         To make changes to the rule group, you provide the token in your request. Network Firewall uses the token
     *         to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the
     *         operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group
     *         again to get a current copy of it with a current token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule group.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule group.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * <p>
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the rule group. You can't change the name of a rule group after you create
     *         it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String ruleGroupName() {
        return ruleGroupName;
    }

    /**
     * <p>
     * An object that defines the rule group rules.
     * </p>
     * <note>
     * <p>
     * You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
     * </p>
     * </note>
     * 
     * @return An object that defines the rule group rules. </p> <note>
     *         <p>
     *         You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
     *         </p>
     */
    public final RuleGroup ruleGroup() {
        return ruleGroup;
    }

    /**
     * <p>
     * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use
     * this to import your existing Suricata compatible rule groups.
     * </p>
     * <note>
     * <p>
     * You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both.
     * </p>
     * </note>
     * <p>
     * You can provide your rule group specification in Suricata flat format through this setting when you create or
     * update your rule group. The call response returns a <a>RuleGroup</a> object that Network Firewall has populated
     * from your string.
     * </p>
     * 
     * @return A string containing stateful rule group rules specifications in Suricata flat format, with one rule per
     *         line. Use this to import your existing Suricata compatible rule groups. </p> <note>
     *         <p>
     *         You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both.
     *         </p>
     *         </note>
     *         <p>
     *         You can provide your rule group specification in Suricata flat format through this setting when you
     *         create or update your rule group. The call response returns a <a>RuleGroup</a> object that Network
     *         Firewall has populated from your string.
     */
    public final String rules() {
        return rules;
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <note>
     * <p>
     * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules. </p> <note>
     *         <p>
     *         This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     *         </p>
     * @see RuleGroupType
     */
    public final RuleGroupType type() {
        return RuleGroupType.fromValue(type);
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <note>
     * <p>
     * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules. </p> <note>
     *         <p>
     *         This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     *         </p>
     * @see RuleGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A description of the rule group.
     * </p>
     * 
     * @return A description of the rule group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
     * request.
     * </p>
     * <p>
     * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
     * actually make the requested changes. The call returns the value that the request would return if you ran it with
     * dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows
     * you to make sure that you have the required permissions to run the request and that your request parameters are
     * valid.
     * </p>
     * <p>
     * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     * </p>
     * 
     * @return Indicates whether you want Network Firewall to just check the validity of the request, rather than run
     *         the request. </p>
     *         <p>
     *         If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
     *         doesn't actually make the requested changes. The call returns the value that the request would return if
     *         you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
     *         resources. This option allows you to make sure that you have the required permissions to run the request
     *         and that your request parameters are valid.
     *         </p>
     *         <p>
     *         If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleGroupRequest)) {
            return false;
        }
        UpdateRuleGroupRequest other = (UpdateRuleGroupRequest) obj;
        return Objects.equals(updateToken(), other.updateToken()) && Objects.equals(ruleGroupArn(), other.ruleGroupArn())
                && Objects.equals(ruleGroupName(), other.ruleGroupName()) && Objects.equals(ruleGroup(), other.ruleGroup())
                && Objects.equals(rules(), other.rules()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuleGroupRequest").add("UpdateToken", updateToken()).add("RuleGroupArn", ruleGroupArn())
                .add("RuleGroupName", ruleGroupName()).add("RuleGroup", ruleGroup()).add("Rules", rules())
                .add("Type", typeAsString()).add("Description", description()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "RuleGroupName":
            return Optional.ofNullable(clazz.cast(ruleGroupName()));
        case "RuleGroup":
            return Optional.ofNullable(clazz.cast(ruleGroup()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleGroupRequest, T> g) {
        return obj -> g.apply((UpdateRuleGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleGroupRequest> {
        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule
         * group. The token marks the state of the rule group resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to
         * ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current
         * copy of it with a current token. Reapply your changes as needed, then try the operation again using the new
         * token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        rule group. The token marks the state of the rule group resource at the time of the request. </p>
         *        <p>
         *        To make changes to the rule group, you provide the token in your request. Network Firewall uses the
         *        token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the
         *        operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group
         *        again to get a current copy of it with a current token. Reapply your changes as needed, then try the
         *        operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule group.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param ruleGroupArn
         *        The Amazon Resource Name (ARN) of the rule group.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param ruleGroupName
         *        The descriptive name of the rule group. You can't change the name of a rule group after you create
         *        it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupName(String ruleGroupName);

        /**
         * <p>
         * An object that defines the rule group rules.
         * </p>
         * <note>
         * <p>
         * You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
         * </p>
         * </note>
         * 
         * @param ruleGroup
         *        An object that defines the rule group rules. </p> <note>
         *        <p>
         *        You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroup(RuleGroup ruleGroup);

        /**
         * <p>
         * An object that defines the rule group rules.
         * </p>
         * <note>
         * <p>
         * You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link RuleGroup.Builder} avoiding the need to
         * create one manually via {@link RuleGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleGroup(RuleGroup)}.
         * 
         * @param ruleGroup
         *        a consumer that will call methods on {@link RuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroup(RuleGroup)
         */
        default Builder ruleGroup(Consumer<RuleGroup.Builder> ruleGroup) {
            return ruleGroup(RuleGroup.builder().applyMutation(ruleGroup).build());
        }

        /**
         * <p>
         * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line.
         * Use this to import your existing Suricata compatible rule groups.
         * </p>
         * <note>
         * <p>
         * You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both.
         * </p>
         * </note>
         * <p>
         * You can provide your rule group specification in Suricata flat format through this setting when you create or
         * update your rule group. The call response returns a <a>RuleGroup</a> object that Network Firewall has
         * populated from your string.
         * </p>
         * 
         * @param rules
         *        A string containing stateful rule group rules specifications in Suricata flat format, with one rule
         *        per line. Use this to import your existing Suricata compatible rule groups. </p> <note>
         *        <p>
         *        You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not
         *        both.
         *        </p>
         *        </note>
         *        <p>
         *        You can provide your rule group specification in Suricata flat format through this setting when you
         *        create or update your rule group. The call response returns a <a>RuleGroup</a> object that Network
         *        Firewall has populated from your string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(String rules);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * <note>
         * <p>
         * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules. </p> <note>
         *        <p>
         *        This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         *        </p>
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * <note>
         * <p>
         * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules. </p> <note>
         *        <p>
         *        This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         *        </p>
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(RuleGroupType type);

        /**
         * <p>
         * A description of the rule group.
         * </p>
         * 
         * @param description
         *        A description of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
         * request.
         * </p>
         * <p>
         * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
         * actually make the requested changes. The call returns the value that the request would return if you ran it
         * with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option
         * allows you to make sure that you have the required permissions to run the request and that your request
         * parameters are valid.
         * </p>
         * <p>
         * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * </p>
         * 
         * @param dryRun
         *        Indicates whether you want Network Firewall to just check the validity of the request, rather than run
         *        the request. </p>
         *        <p>
         *        If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
         *        doesn't actually make the requested changes. The call returns the value that the request would return
         *        if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
         *        resources. This option allows you to make sure that you have the required permissions to run the
         *        request and that your request parameters are valid.
         *        </p>
         *        <p>
         *        If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String updateToken;

        private String ruleGroupArn;

        private String ruleGroupName;

        private RuleGroup ruleGroup;

        private String rules;

        private String type;

        private String description;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleGroupRequest model) {
            super(model);
            updateToken(model.updateToken);
            ruleGroupArn(model.ruleGroupArn);
            ruleGroupName(model.ruleGroupName);
            ruleGroup(model.ruleGroup);
            rules(model.rules);
            type(model.type);
            description(model.description);
            dryRun(model.dryRun);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        @Transient
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        @Transient
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupName() {
            return ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        @Transient
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final RuleGroup.Builder getRuleGroup() {
            return ruleGroup != null ? ruleGroup.toBuilder() : null;
        }

        public final void setRuleGroup(RuleGroup.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleGroup(RuleGroup ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final String getRules() {
            return rules;
        }

        public final void setRules(String rules) {
            this.rules = rules;
        }

        @Override
        @Transient
        public final Builder rules(String rules) {
            this.rules = rules;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        @Transient
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleGroupRequest build() {
            return new UpdateRuleGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
