/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.Header;
import software.amazon.awssdk.services.networkfirewall.model.RuleOption;
import software.amazon.awssdk.services.networkfirewall.model.RuleOptionsCopier;
import software.amazon.awssdk.services.networkfirewall.model.StatefulAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatefulRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatefulRule> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(StatefulRule.getter(StatefulRule::actionAsString)).setter(StatefulRule.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Header> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Header").getter(StatefulRule.getter(StatefulRule::header)).setter(StatefulRule.setter(Builder::header)).constructor(Header::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()}).build();
    private static final SdkField<List<RuleOption>> RULE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleOptions").getter(StatefulRule.getter(StatefulRule::ruleOptions)).setter(StatefulRule.setter(Builder::ruleOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, HEADER_FIELD, RULE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final Header header;
    private final List<RuleOption> ruleOptions;

    private StatefulRule(BuilderImpl builder) {
        this.action = builder.action;
        this.header = builder.header;
        this.ruleOptions = builder.ruleOptions;
    }

    public final StatefulAction action() {
        return StatefulAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Header header() {
        return this.header;
    }

    public final boolean hasRuleOptions() {
        return this.ruleOptions != null && !(this.ruleOptions instanceof SdkAutoConstructList);
    }

    public final List<RuleOption> ruleOptions() {
        return this.ruleOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleOptions() ? this.ruleOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulRule)) {
            return false;
        }
        StatefulRule other = (StatefulRule)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.header(), other.header()) && this.hasRuleOptions() == other.hasRuleOptions() && Objects.equals(this.ruleOptions(), other.ruleOptions());
    }

    public final String toString() {
        return ToString.builder((String)"StatefulRule").add("Action", (Object)this.actionAsString()).add("Header", (Object)this.header()).add("RuleOptions", this.hasRuleOptions() ? this.ruleOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "RuleOptions": {
                return Optional.ofNullable(clazz.cast(this.ruleOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatefulRule, T> g) {
        return obj -> g.apply((StatefulRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Header header;
        private List<RuleOption> ruleOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulRule model) {
            this.action(model.action);
            this.header(model.header);
            this.ruleOptions(model.ruleOptions);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(StatefulAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Header.Builder getHeader() {
            return this.header != null ? this.header.toBuilder() : null;
        }

        public final void setHeader(Header.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        @Transient
        public final Builder header(Header header) {
            this.header = header;
            return this;
        }

        public final List<RuleOption.Builder> getRuleOptions() {
            List<RuleOption.Builder> result = RuleOptionsCopier.copyToBuilder(this.ruleOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleOptions(Collection<RuleOption.BuilderImpl> ruleOptions) {
            this.ruleOptions = RuleOptionsCopier.copyFromBuilder(ruleOptions);
        }

        @Override
        @Transient
        public final Builder ruleOptions(Collection<RuleOption> ruleOptions) {
            this.ruleOptions = RuleOptionsCopier.copy(ruleOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ruleOptions(RuleOption ... ruleOptions) {
            this.ruleOptions(Arrays.asList(ruleOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ruleOptions(Consumer<RuleOption.Builder> ... ruleOptions) {
            this.ruleOptions(Stream.of(ruleOptions).map(c -> (RuleOption)((RuleOption.Builder)RuleOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StatefulRule build() {
            return new StatefulRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatefulRule> {
        public Builder action(String var1);

        public Builder action(StatefulAction var1);

        public Builder header(Header var1);

        default public Builder header(Consumer<Header.Builder> header) {
            return this.header((Header)((Header.Builder)Header.builder().applyMutation(header)).build());
        }

        public Builder ruleOptions(Collection<RuleOption> var1);

        public Builder ruleOptions(RuleOption ... var1);

        public Builder ruleOptions(Consumer<RuleOption.Builder> ... var1);
    }
}

