/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFirewallPolicyRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateFirewallPolicyRequest.Builder, CreateFirewallPolicyRequest> {
    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyName").getter(getter(CreateFirewallPolicyRequest::firewallPolicyName))
            .setter(setter(Builder::firewallPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build())
            .build();

    private static final SdkField<FirewallPolicy> FIREWALL_POLICY_FIELD = SdkField
            .<FirewallPolicy> builder(MarshallingType.SDK_POJO).memberName("FirewallPolicy")
            .getter(getter(CreateFirewallPolicyRequest::firewallPolicy)).setter(setter(Builder::firewallPolicy))
            .constructor(FirewallPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFirewallPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFirewallPolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(CreateFirewallPolicyRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_NAME_FIELD,
            FIREWALL_POLICY_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, DRY_RUN_FIELD));

    private final String firewallPolicyName;

    private final FirewallPolicy firewallPolicy;

    private final String description;

    private final List<Tag> tags;

    private final Boolean dryRun;

    private CreateFirewallPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicy = builder.firewallPolicy;
        this.description = builder.description;
        this.tags = builder.tags;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
     * </p>
     * 
     * @return The descriptive name of the firewall policy. You can't change the name of a firewall policy after you
     *         create it.
     */
    public final String firewallPolicyName() {
        return firewallPolicyName;
    }

    /**
     * <p>
     * The rule groups and policy actions to use in the firewall policy.
     * </p>
     * 
     * @return The rule groups and policy actions to use in the firewall policy.
     */
    public final FirewallPolicy firewallPolicy() {
        return firewallPolicy;
    }

    /**
     * <p>
     * A description of the firewall policy.
     * </p>
     * 
     * @return A description of the firewall policy.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
     * request.
     * </p>
     * <p>
     * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
     * actually make the requested changes. The call returns the value that the request would return if you ran it with
     * dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows
     * you to make sure that you have the required permissions to run the request and that your request parameters are
     * valid.
     * </p>
     * <p>
     * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     * </p>
     * 
     * @return Indicates whether you want Network Firewall to just check the validity of the request, rather than run
     *         the request. </p>
     *         <p>
     *         If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
     *         doesn't actually make the requested changes. The call returns the value that the request would return if
     *         you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
     *         resources. This option allows you to make sure that you have the required permissions to run the request
     *         and that your request parameters are valid.
     *         </p>
     *         <p>
     *         If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallPolicyRequest)) {
            return false;
        }
        CreateFirewallPolicyRequest other = (CreateFirewallPolicyRequest) obj;
        return Objects.equals(firewallPolicyName(), other.firewallPolicyName())
                && Objects.equals(firewallPolicy(), other.firewallPolicy()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFirewallPolicyRequest").add("FirewallPolicyName", firewallPolicyName())
                .add("FirewallPolicy", firewallPolicy()).add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallPolicyName":
            return Optional.ofNullable(clazz.cast(firewallPolicyName()));
        case "FirewallPolicy":
            return Optional.ofNullable(clazz.cast(firewallPolicy()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallPolicyRequest, T> g) {
        return obj -> g.apply((CreateFirewallPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFirewallPolicyRequest> {
        /**
         * <p>
         * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create
         * it.
         * </p>
         * 
         * @param firewallPolicyName
         *        The descriptive name of the firewall policy. You can't change the name of a firewall policy after you
         *        create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyName(String firewallPolicyName);

        /**
         * <p>
         * The rule groups and policy actions to use in the firewall policy.
         * </p>
         * 
         * @param firewallPolicy
         *        The rule groups and policy actions to use in the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicy(FirewallPolicy firewallPolicy);

        /**
         * <p>
         * The rule groups and policy actions to use in the firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirewallPolicy.Builder} avoiding the need
         * to create one manually via {@link FirewallPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #firewallPolicy(FirewallPolicy)}.
         * 
         * @param firewallPolicy
         *        a consumer that will call methods on {@link FirewallPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallPolicy(FirewallPolicy)
         */
        default Builder firewallPolicy(Consumer<FirewallPolicy.Builder> firewallPolicy) {
            return firewallPolicy(FirewallPolicy.builder().applyMutation(firewallPolicy).build());
        }

        /**
         * <p>
         * A description of the firewall policy.
         * </p>
         * 
         * @param description
         *        A description of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
         * request.
         * </p>
         * <p>
         * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
         * actually make the requested changes. The call returns the value that the request would return if you ran it
         * with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option
         * allows you to make sure that you have the required permissions to run the request and that your request
         * parameters are valid.
         * </p>
         * <p>
         * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * </p>
         * 
         * @param dryRun
         *        Indicates whether you want Network Firewall to just check the validity of the request, rather than run
         *        the request. </p>
         *        <p>
         *        If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
         *        doesn't actually make the requested changes. The call returns the value that the request would return
         *        if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
         *        resources. This option allows you to make sure that you have the required permissions to run the
         *        request and that your request parameters are valid.
         *        </p>
         *        <p>
         *        If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String firewallPolicyName;

        private FirewallPolicy firewallPolicy;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallPolicyRequest model) {
            super(model);
            firewallPolicyName(model.firewallPolicyName);
            firewallPolicy(model.firewallPolicy);
            description(model.description);
            tags(model.tags);
            dryRun(model.dryRun);
        }

        public final String getFirewallPolicyName() {
            return firewallPolicyName;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final FirewallPolicy.Builder getFirewallPolicy() {
            return firewallPolicy != null ? firewallPolicy.toBuilder() : null;
        }

        public final void setFirewallPolicy(FirewallPolicy.BuilderImpl firewallPolicy) {
            this.firewallPolicy = firewallPolicy != null ? firewallPolicy.build() : null;
        }

        @Override
        public final Builder firewallPolicy(FirewallPolicy firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFirewallPolicyRequest build() {
            return new CreateFirewallPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
