/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The basic rule criteria for AWS Network Firewall to use to inspect packet headers in stateful traffic flow
 * inspection. Traffic flows that match the criteria are a match for the corresponding <a>StatefulRule</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Header implements SdkPojo, Serializable, ToCopyableBuilder<Header.Builder, Header> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Header::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Header::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePort").getter(getter(Header::sourcePort)).setter(setter(Builder::sourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(Header::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(Header::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPort").getter(getter(Header::destinationPort)).setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, SOURCE_FIELD,
            SOURCE_PORT_FIELD, DIRECTION_FIELD, DESTINATION_FIELD, DESTINATION_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final String source;

    private final String sourcePort;

    private final String direction;

    private final String destination;

    private final String destinationPort;

    private Header(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.source = builder.source;
        this.sourcePort = builder.sourcePort;
        this.direction = builder.direction;
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
    }

    /**
     * <p>
     * The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on the
     * internet is IP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link StatefulRuleProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and
     *         on the internet is IP.
     * @see StatefulRuleProtocol
     */
    public final StatefulRuleProtocol protocol() {
        return StatefulRuleProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on the
     * internet is IP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link StatefulRuleProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and
     *         on the internet is IP.
     * @see StatefulRuleProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify
     * <code>ANY</code>.
     * </p>
     * <p>
     * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network
     * Firewall supports all address ranges for IPv4.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
     * <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * 
     * @return The source IP address or address range to inspect for, in CIDR notation. To match with any address,
     *         specify <code>ANY</code>. </p>
     *         <p>
     *         Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
     *         Network Firewall supports all address ranges for IPv4.
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for the IP address 192.0.2.44, specify
     *         <code>192.0.2.44/32</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *         <code>192.0.2.0/24</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about CIDR notation, see the Wikipedia entry <a
     *         href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can
     * specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you
     *         can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String sourcePort() {
        return sourcePort;
    }

    /**
     * <p>
     * The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional
     * traffic, both from the source to the destination and from the destination to the source. If set to
     * <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link StatefulRuleDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches
     *         bidirectional traffic, both from the source to the destination and from the destination to the source. If
     *         set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the
     *         destination.
     * @see StatefulRuleDirection
     */
    public final StatefulRuleDirection direction() {
        return StatefulRuleDirection.fromValue(direction);
    }

    /**
     * <p>
     * The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional
     * traffic, both from the source to the destination and from the destination to the source. If set to
     * <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link StatefulRuleDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches
     *         bidirectional traffic, both from the source to the destination and from the destination to the source. If
     *         set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the
     *         destination.
     * @see StatefulRuleDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify
     * <code>ANY</code>.
     * </p>
     * <p>
     * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network
     * Firewall supports all address ranges for IPv4.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
     * <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * 
     * @return The destination IP address or address range to inspect for, in CIDR notation. To match with any address,
     *         specify <code>ANY</code>. </p>
     *         <p>
     *         Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
     *         Network Firewall supports all address ranges for IPv4.
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for the IP address 192.0.2.44, specify
     *         <code>192.0.2.44/32</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *         <code>192.0.2.0/24</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about CIDR notation, see the Wikipedia entry <a
     *         href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and you
     * can specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The destination port to inspect for. You can specify an individual port, for example <code>1994</code>
     *         and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String destinationPort() {
        return destinationPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Header)) {
            return false;
        }
        Header other = (Header) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(source(), other.source())
                && Objects.equals(sourcePort(), other.sourcePort())
                && Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationPort(), other.destinationPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Header").add("Protocol", protocolAsString()).add("Source", source())
                .add("SourcePort", sourcePort()).add("Direction", directionAsString()).add("Destination", destination())
                .add("DestinationPort", destinationPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourcePort":
            return Optional.ofNullable(clazz.cast(sourcePort()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Header, T> g) {
        return obj -> g.apply((Header) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Header> {
        /**
         * <p>
         * The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on
         * the internet is IP.
         * </p>
         * 
         * @param protocol
         *        The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS
         *        and on the internet is IP.
         * @see StatefulRuleProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatefulRuleProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS and on
         * the internet is IP.
         * </p>
         * 
         * @param protocol
         *        The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on AWS
         *        and on the internet is IP.
         * @see StatefulRuleProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatefulRuleProtocol
         */
        Builder protocol(StatefulRuleProtocol protocol);

        /**
         * <p>
         * The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify
         * <code>ANY</code>.
         * </p>
         * <p>
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network
         * Firewall supports all address ranges for IPv4.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
         * <code>192.0.2.0/24</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a
         * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
         * </p>
         * 
         * @param source
         *        The source IP address or address range to inspect for, in CIDR notation. To match with any address,
         *        specify <code>ANY</code>. </p>
         *        <p>
         *        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
         *        Network Firewall supports all address ranges for IPv4.
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for the IP address 192.0.2.44, specify
         *        <code>192.0.2.44/32</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
         *        <code>192.0.2.0/24</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about CIDR notation, see the Wikipedia entry <a
         *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
         *        Routing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can
         * specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
         * </p>
         * 
         * @param sourcePort
         *        The source port to inspect for. You can specify an individual port, for example <code>1994</code> and
         *        you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePort(String sourcePort);

        /**
         * <p>
         * The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional
         * traffic, both from the source to the destination and from the destination to the source. If set to
         * <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.
         * </p>
         * 
         * @param direction
         *        The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches
         *        bidirectional traffic, both from the source to the destination and from the destination to the source.
         *        If set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the
         *        destination.
         * @see StatefulRuleDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatefulRuleDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional
         * traffic, both from the source to the destination and from the destination to the source. If set to
         * <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.
         * </p>
         * 
         * @param direction
         *        The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches
         *        bidirectional traffic, both from the source to the destination and from the destination to the source.
         *        If set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the
         *        destination.
         * @see StatefulRuleDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatefulRuleDirection
         */
        Builder direction(StatefulRuleDirection direction);

        /**
         * <p>
         * The destination IP address or address range to inspect for, in CIDR notation. To match with any address,
         * specify <code>ANY</code>.
         * </p>
         * <p>
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network
         * Firewall supports all address ranges for IPv4.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
         * <code>192.0.2.0/24</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a
         * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
         * </p>
         * 
         * @param destination
         *        The destination IP address or address range to inspect for, in CIDR notation. To match with any
         *        address, specify <code>ANY</code>. </p>
         *        <p>
         *        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
         *        Network Firewall supports all address ranges for IPv4.
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for the IP address 192.0.2.44, specify
         *        <code>192.0.2.44/32</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
         *        <code>192.0.2.0/24</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about CIDR notation, see the Wikipedia entry <a
         *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
         *        Routing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and
         * you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         * <code>ANY</code>.
         * </p>
         * 
         * @param destinationPort
         *        The destination port to inspect for. You can specify an individual port, for example <code>1994</code>
         *        and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(String destinationPort);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private String source;

        private String sourcePort;

        private String direction;

        private String destination;

        private String destinationPort;

        private BuilderImpl() {
        }

        private BuilderImpl(Header model) {
            protocol(model.protocol);
            source(model.source);
            sourcePort(model.sourcePort);
            direction(model.direction);
            destination(model.destination);
            destinationPort(model.destinationPort);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(StatefulRuleProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourcePort() {
            return sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(StatefulRuleDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        @Override
        public Header build() {
            return new Header(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
