/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group.
 * You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
 * </p>
 * <p>
 * AWS Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to
 * inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic
 * flow.
 * </p>
 * <p>
 * To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a
 * firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall policy in
 * more than one firewall.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroup implements SdkPojo, Serializable, ToCopyableBuilder<RuleGroup.Builder, RuleGroup> {
    private static final SdkField<RuleVariables> RULE_VARIABLES_FIELD = SdkField
            .<RuleVariables> builder(MarshallingType.SDK_POJO).memberName("RuleVariables")
            .getter(getter(RuleGroup::ruleVariables)).setter(setter(Builder::ruleVariables)).constructor(RuleVariables::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVariables").build()).build();

    private static final SdkField<RulesSource> RULES_SOURCE_FIELD = SdkField.<RulesSource> builder(MarshallingType.SDK_POJO)
            .memberName("RulesSource").getter(getter(RuleGroup::rulesSource)).setter(setter(Builder::rulesSource))
            .constructor(RulesSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSource").build()).build();

    private static final SdkField<StatefulRuleOptions> STATEFUL_RULE_OPTIONS_FIELD = SdkField
            .<StatefulRuleOptions> builder(MarshallingType.SDK_POJO).memberName("StatefulRuleOptions")
            .getter(getter(RuleGroup::statefulRuleOptions)).setter(setter(Builder::statefulRuleOptions))
            .constructor(StatefulRuleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_VARIABLES_FIELD,
            RULES_SOURCE_FIELD, STATEFUL_RULE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RuleVariables ruleVariables;

    private final RulesSource rulesSource;

    private final StatefulRuleOptions statefulRuleOptions;

    private RuleGroup(BuilderImpl builder) {
        this.ruleVariables = builder.ruleVariables;
        this.rulesSource = builder.rulesSource;
        this.statefulRuleOptions = builder.statefulRuleOptions;
    }

    /**
     * <p>
     * Settings that are available for use in the rules in the rule group. You can only use these for stateful rule
     * groups.
     * </p>
     * 
     * @return Settings that are available for use in the rules in the rule group. You can only use these for stateful
     *         rule groups.
     */
    public final RuleVariables ruleVariables() {
        return ruleVariables;
    }

    /**
     * <p>
     * The stateful rules or stateless rules for the rule group.
     * </p>
     * 
     * @return The stateful rules or stateless rules for the rule group.
     */
    public final RulesSource rulesSource() {
        return rulesSource;
    }

    /**
     * <p>
     * Additional options governing how Network Firewall handles stateful rules. The policies where you use your
     * stateful rule group must have stateful rule options settings that are compatible with these settings.
     * </p>
     * 
     * @return Additional options governing how Network Firewall handles stateful rules. The policies where you use your
     *         stateful rule group must have stateful rule options settings that are compatible with these settings.
     */
    public final StatefulRuleOptions statefulRuleOptions() {
        return statefulRuleOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleVariables());
        hashCode = 31 * hashCode + Objects.hashCode(rulesSource());
        hashCode = 31 * hashCode + Objects.hashCode(statefulRuleOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroup)) {
            return false;
        }
        RuleGroup other = (RuleGroup) obj;
        return Objects.equals(ruleVariables(), other.ruleVariables()) && Objects.equals(rulesSource(), other.rulesSource())
                && Objects.equals(statefulRuleOptions(), other.statefulRuleOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroup").add("RuleVariables", ruleVariables()).add("RulesSource", rulesSource())
                .add("StatefulRuleOptions", statefulRuleOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleVariables":
            return Optional.ofNullable(clazz.cast(ruleVariables()));
        case "RulesSource":
            return Optional.ofNullable(clazz.cast(rulesSource()));
        case "StatefulRuleOptions":
            return Optional.ofNullable(clazz.cast(statefulRuleOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroup, T> g) {
        return obj -> g.apply((RuleGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroup> {
        /**
         * <p>
         * Settings that are available for use in the rules in the rule group. You can only use these for stateful rule
         * groups.
         * </p>
         * 
         * @param ruleVariables
         *        Settings that are available for use in the rules in the rule group. You can only use these for
         *        stateful rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleVariables(RuleVariables ruleVariables);

        /**
         * <p>
         * Settings that are available for use in the rules in the rule group. You can only use these for stateful rule
         * groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleVariables.Builder} avoiding the need
         * to create one manually via {@link RuleVariables#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleVariables.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleVariables(RuleVariables)}.
         * 
         * @param ruleVariables
         *        a consumer that will call methods on {@link RuleVariables.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleVariables(RuleVariables)
         */
        default Builder ruleVariables(Consumer<RuleVariables.Builder> ruleVariables) {
            return ruleVariables(RuleVariables.builder().applyMutation(ruleVariables).build());
        }

        /**
         * <p>
         * The stateful rules or stateless rules for the rule group.
         * </p>
         * 
         * @param rulesSource
         *        The stateful rules or stateless rules for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesSource(RulesSource rulesSource);

        /**
         * <p>
         * The stateful rules or stateless rules for the rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link RulesSource.Builder} avoiding the need to
         * create one manually via {@link RulesSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link RulesSource.Builder#build()} is called immediately and its result
         * is passed to {@link #rulesSource(RulesSource)}.
         * 
         * @param rulesSource
         *        a consumer that will call methods on {@link RulesSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesSource(RulesSource)
         */
        default Builder rulesSource(Consumer<RulesSource.Builder> rulesSource) {
            return rulesSource(RulesSource.builder().applyMutation(rulesSource).build());
        }

        /**
         * <p>
         * Additional options governing how Network Firewall handles stateful rules. The policies where you use your
         * stateful rule group must have stateful rule options settings that are compatible with these settings.
         * </p>
         * 
         * @param statefulRuleOptions
         *        Additional options governing how Network Firewall handles stateful rules. The policies where you use
         *        your stateful rule group must have stateful rule options settings that are compatible with these
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleOptions(StatefulRuleOptions statefulRuleOptions);

        /**
         * <p>
         * Additional options governing how Network Firewall handles stateful rules. The policies where you use your
         * stateful rule group must have stateful rule options settings that are compatible with these settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatefulRuleOptions.Builder} avoiding the
         * need to create one manually via {@link StatefulRuleOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatefulRuleOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #statefulRuleOptions(StatefulRuleOptions)}.
         * 
         * @param statefulRuleOptions
         *        a consumer that will call methods on {@link StatefulRuleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRuleOptions(StatefulRuleOptions)
         */
        default Builder statefulRuleOptions(Consumer<StatefulRuleOptions.Builder> statefulRuleOptions) {
            return statefulRuleOptions(StatefulRuleOptions.builder().applyMutation(statefulRuleOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleVariables ruleVariables;

        private RulesSource rulesSource;

        private StatefulRuleOptions statefulRuleOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroup model) {
            ruleVariables(model.ruleVariables);
            rulesSource(model.rulesSource);
            statefulRuleOptions(model.statefulRuleOptions);
        }

        public final RuleVariables.Builder getRuleVariables() {
            return ruleVariables != null ? ruleVariables.toBuilder() : null;
        }

        public final void setRuleVariables(RuleVariables.BuilderImpl ruleVariables) {
            this.ruleVariables = ruleVariables != null ? ruleVariables.build() : null;
        }

        @Override
        public final Builder ruleVariables(RuleVariables ruleVariables) {
            this.ruleVariables = ruleVariables;
            return this;
        }

        public final RulesSource.Builder getRulesSource() {
            return rulesSource != null ? rulesSource.toBuilder() : null;
        }

        public final void setRulesSource(RulesSource.BuilderImpl rulesSource) {
            this.rulesSource = rulesSource != null ? rulesSource.build() : null;
        }

        @Override
        public final Builder rulesSource(RulesSource rulesSource) {
            this.rulesSource = rulesSource;
            return this;
        }

        public final StatefulRuleOptions.Builder getStatefulRuleOptions() {
            return statefulRuleOptions != null ? statefulRuleOptions.toBuilder() : null;
        }

        public final void setStatefulRuleOptions(StatefulRuleOptions.BuilderImpl statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions != null ? statefulRuleOptions.build() : null;
        }

        @Override
        public final Builder statefulRuleOptions(StatefulRuleOptions statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions;
            return this;
        }

        @Override
        public RuleGroup build() {
            return new RuleGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
