/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stateless or stateful rules definitions for use in a single rule group. Each rule group requires a single
 * <code>RulesSource</code>. You can use an instance of this for either stateless rules or stateful rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RulesSource implements SdkPojo, Serializable, ToCopyableBuilder<RulesSource.Builder, RulesSource> {
    private static final SdkField<String> RULES_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RulesString").getter(getter(RulesSource::rulesString)).setter(setter(Builder::rulesString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesString").build()).build();

    private static final SdkField<RulesSourceList> RULES_SOURCE_LIST_FIELD = SdkField
            .<RulesSourceList> builder(MarshallingType.SDK_POJO).memberName("RulesSourceList")
            .getter(getter(RulesSource::rulesSourceList)).setter(setter(Builder::rulesSourceList))
            .constructor(RulesSourceList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSourceList").build()).build();

    private static final SdkField<List<StatefulRule>> STATEFUL_RULES_FIELD = SdkField
            .<List<StatefulRule>> builder(MarshallingType.LIST)
            .memberName("StatefulRules")
            .getter(getter(RulesSource::statefulRules))
            .setter(setter(Builder::statefulRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatefulRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatefulRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StatelessRulesAndCustomActions> STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD = SdkField
            .<StatelessRulesAndCustomActions> builder(MarshallingType.SDK_POJO)
            .memberName("StatelessRulesAndCustomActions")
            .getter(getter(RulesSource::statelessRulesAndCustomActions))
            .setter(setter(Builder::statelessRulesAndCustomActions))
            .constructor(StatelessRulesAndCustomActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRulesAndCustomActions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_STRING_FIELD,
            RULES_SOURCE_LIST_FIELD, STATEFUL_RULES_FIELD, STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rulesString;

    private final RulesSourceList rulesSourceList;

    private final List<StatefulRule> statefulRules;

    private final StatelessRulesAndCustomActions statelessRulesAndCustomActions;

    private RulesSource(BuilderImpl builder) {
        this.rulesString = builder.rulesString;
        this.rulesSourceList = builder.rulesSourceList;
        this.statefulRules = builder.statefulRules;
        this.statelessRulesAndCustomActions = builder.statelessRulesAndCustomActions;
    }

    /**
     * <p>
     * Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules. Suricata
     * is an open-source network IPS that includes a standard rule-based language for network traffic inspection.
     * </p>
     * <p>
     * These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so this
     * type of rule group doesn't have a separate action setting.
     * </p>
     * 
     * @return Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
     *         Suricata is an open-source network IPS that includes a standard rule-based language for network traffic
     *         inspection.</p>
     *         <p>
     *         These rules contain the inspection criteria and the action to take for traffic that matches the criteria,
     *         so this type of rule group doesn't have a separate action setting.
     */
    public final String rulesString() {
        return rulesString;
    }

    /**
     * <p>
     * Stateful inspection criteria for a domain list rule group.
     * </p>
     * 
     * @return Stateful inspection criteria for a domain list rule group.
     */
    public final RulesSourceList rulesSourceList() {
        return rulesSourceList;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatefulRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatefulRules() {
        return statefulRules != null && !(statefulRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use this
     * option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule
     * options. For information about the Suricata <code>Rules</code> format, see <a
     * href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatefulRules} method.
     * </p>
     * 
     * @return An array of individual stateful rules inspection criteria to be used together in a stateful rule group.
     *         Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction,
     *         and rule options. For information about the Suricata <code>Rules</code> format, see <a
     *         href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
     */
    public final List<StatefulRule> statefulRules() {
        return statefulRules;
    }

    /**
     * <p>
     * Stateless inspection criteria to be used in a stateless rule group.
     * </p>
     * 
     * @return Stateless inspection criteria to be used in a stateless rule group.
     */
    public final StatelessRulesAndCustomActions statelessRulesAndCustomActions() {
        return statelessRulesAndCustomActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rulesString());
        hashCode = 31 * hashCode + Objects.hashCode(rulesSourceList());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulRules() ? statefulRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statelessRulesAndCustomActions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesSource)) {
            return false;
        }
        RulesSource other = (RulesSource) obj;
        return Objects.equals(rulesString(), other.rulesString()) && Objects.equals(rulesSourceList(), other.rulesSourceList())
                && hasStatefulRules() == other.hasStatefulRules() && Objects.equals(statefulRules(), other.statefulRules())
                && Objects.equals(statelessRulesAndCustomActions(), other.statelessRulesAndCustomActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RulesSource").add("RulesString", rulesString()).add("RulesSourceList", rulesSourceList())
                .add("StatefulRules", hasStatefulRules() ? statefulRules() : null)
                .add("StatelessRulesAndCustomActions", statelessRulesAndCustomActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RulesString":
            return Optional.ofNullable(clazz.cast(rulesString()));
        case "RulesSourceList":
            return Optional.ofNullable(clazz.cast(rulesSourceList()));
        case "StatefulRules":
            return Optional.ofNullable(clazz.cast(statefulRules()));
        case "StatelessRulesAndCustomActions":
            return Optional.ofNullable(clazz.cast(statelessRulesAndCustomActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RulesSource, T> g) {
        return obj -> g.apply((RulesSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RulesSource> {
        /**
         * <p>
         * Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
         * Suricata is an open-source network IPS that includes a standard rule-based language for network traffic
         * inspection.
         * </p>
         * <p>
         * These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so
         * this type of rule group doesn't have a separate action setting.
         * </p>
         * 
         * @param rulesString
         *        Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
         *        Suricata is an open-source network IPS that includes a standard rule-based language for network
         *        traffic inspection.</p>
         *        <p>
         *        These rules contain the inspection criteria and the action to take for traffic that matches the
         *        criteria, so this type of rule group doesn't have a separate action setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesString(String rulesString);

        /**
         * <p>
         * Stateful inspection criteria for a domain list rule group.
         * </p>
         * 
         * @param rulesSourceList
         *        Stateful inspection criteria for a domain list rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesSourceList(RulesSourceList rulesSourceList);

        /**
         * <p>
         * Stateful inspection criteria for a domain list rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link RulesSourceList.Builder} avoiding the
         * need to create one manually via {@link RulesSourceList#builder()}.
         *
         * When the {@link Consumer} completes, {@link RulesSourceList.Builder#build()} is called immediately and its
         * result is passed to {@link #rulesSourceList(RulesSourceList)}.
         * 
         * @param rulesSourceList
         *        a consumer that will call methods on {@link RulesSourceList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesSourceList(RulesSourceList)
         */
        default Builder rulesSourceList(Consumer<RulesSourceList.Builder> rulesSourceList) {
            return rulesSourceList(RulesSourceList.builder().applyMutation(rulesSourceList).build());
        }

        /**
         * <p>
         * An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use
         * this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and
         * rule options. For information about the Suricata <code>Rules</code> format, see <a
         * href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
         * </p>
         * 
         * @param statefulRules
         *        An array of individual stateful rules inspection criteria to be used together in a stateful rule
         *        group. Use this option to specify simple Suricata rules with protocol, source and destination, ports,
         *        direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a
         *        href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRules(Collection<StatefulRule> statefulRules);

        /**
         * <p>
         * An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use
         * this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and
         * rule options. For information about the Suricata <code>Rules</code> format, see <a
         * href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
         * </p>
         * 
         * @param statefulRules
         *        An array of individual stateful rules inspection criteria to be used together in a stateful rule
         *        group. Use this option to specify simple Suricata rules with protocol, source and destination, ports,
         *        direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a
         *        href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRules(StatefulRule... statefulRules);

        /**
         * <p>
         * An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use
         * this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and
         * rule options. For information about the Suricata <code>Rules</code> format, see <a
         * href="https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#">Rules Format</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StatefulRule>.Builder} avoiding the
         * need to create one manually via {@link List<StatefulRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatefulRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #statefulRules(List<StatefulRule>)}.
         * 
         * @param statefulRules
         *        a consumer that will call methods on {@link List<StatefulRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRules(List<StatefulRule>)
         */
        Builder statefulRules(Consumer<StatefulRule.Builder>... statefulRules);

        /**
         * <p>
         * Stateless inspection criteria to be used in a stateless rule group.
         * </p>
         * 
         * @param statelessRulesAndCustomActions
         *        Stateless inspection criteria to be used in a stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRulesAndCustomActions(StatelessRulesAndCustomActions statelessRulesAndCustomActions);

        /**
         * <p>
         * Stateless inspection criteria to be used in a stateless rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatelessRulesAndCustomActions.Builder}
         * avoiding the need to create one manually via {@link StatelessRulesAndCustomActions#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatelessRulesAndCustomActions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #statelessRulesAndCustomActions(StatelessRulesAndCustomActions)}.
         * 
         * @param statelessRulesAndCustomActions
         *        a consumer that will call methods on {@link StatelessRulesAndCustomActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRulesAndCustomActions(StatelessRulesAndCustomActions)
         */
        default Builder statelessRulesAndCustomActions(
                Consumer<StatelessRulesAndCustomActions.Builder> statelessRulesAndCustomActions) {
            return statelessRulesAndCustomActions(StatelessRulesAndCustomActions.builder()
                    .applyMutation(statelessRulesAndCustomActions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String rulesString;

        private RulesSourceList rulesSourceList;

        private List<StatefulRule> statefulRules = DefaultSdkAutoConstructList.getInstance();

        private StatelessRulesAndCustomActions statelessRulesAndCustomActions;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesSource model) {
            rulesString(model.rulesString);
            rulesSourceList(model.rulesSourceList);
            statefulRules(model.statefulRules);
            statelessRulesAndCustomActions(model.statelessRulesAndCustomActions);
        }

        public final String getRulesString() {
            return rulesString;
        }

        public final void setRulesString(String rulesString) {
            this.rulesString = rulesString;
        }

        @Override
        public final Builder rulesString(String rulesString) {
            this.rulesString = rulesString;
            return this;
        }

        public final RulesSourceList.Builder getRulesSourceList() {
            return rulesSourceList != null ? rulesSourceList.toBuilder() : null;
        }

        public final void setRulesSourceList(RulesSourceList.BuilderImpl rulesSourceList) {
            this.rulesSourceList = rulesSourceList != null ? rulesSourceList.build() : null;
        }

        @Override
        public final Builder rulesSourceList(RulesSourceList rulesSourceList) {
            this.rulesSourceList = rulesSourceList;
            return this;
        }

        public final List<StatefulRule.Builder> getStatefulRules() {
            List<StatefulRule.Builder> result = StatefulRulesCopier.copyToBuilder(this.statefulRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRules(Collection<StatefulRule.BuilderImpl> statefulRules) {
            this.statefulRules = StatefulRulesCopier.copyFromBuilder(statefulRules);
        }

        @Override
        public final Builder statefulRules(Collection<StatefulRule> statefulRules) {
            this.statefulRules = StatefulRulesCopier.copy(statefulRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRules(StatefulRule... statefulRules) {
            statefulRules(Arrays.asList(statefulRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRules(Consumer<StatefulRule.Builder>... statefulRules) {
            statefulRules(Stream.of(statefulRules).map(c -> StatefulRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StatelessRulesAndCustomActions.Builder getStatelessRulesAndCustomActions() {
            return statelessRulesAndCustomActions != null ? statelessRulesAndCustomActions.toBuilder() : null;
        }

        public final void setStatelessRulesAndCustomActions(
                StatelessRulesAndCustomActions.BuilderImpl statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions != null ? statelessRulesAndCustomActions.build()
                    : null;
        }

        @Override
        public final Builder statelessRulesAndCustomActions(StatelessRulesAndCustomActions statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions;
            return this;
        }

        @Override
        public RulesSource build() {
            return new RulesSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
