/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifier for a single stateful rule group, used in a firewall policy to refer to a rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatefulRuleGroupReference implements SdkPojo, Serializable,
        ToCopyableBuilder<StatefulRuleGroupReference.Builder, StatefulRuleGroupReference> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(StatefulRuleGroupReference::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(StatefulRuleGroupReference::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<StatefulRuleGroupOverride> OVERRIDE_FIELD = SdkField
            .<StatefulRuleGroupOverride> builder(MarshallingType.SDK_POJO).memberName("Override")
            .getter(getter(StatefulRuleGroupReference::override)).setter(setter(Builder::override))
            .constructor(StatefulRuleGroupOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            PRIORITY_FIELD, OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final Integer priority;

    private final StatefulRuleGroupOverride override;

    private StatefulRuleGroupReference(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.priority = builder.priority;
        this.override = builder.override;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stateful rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stateful rule group.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * An integer setting that indicates the order in which to run the stateful rule groups in a single
     * <a>FirewallPolicy</a>. This setting only applies to firewall policies that specify the <code>STRICT_ORDER</code>
     * rule order in the stateful engine options settings.
     * </p>
     * <p>
     * Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest
     * priority setting. You must ensure that the priority settings are unique within each policy.
     * </p>
     * <p>
     * You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups
     * later, number them so there's a wide range in between, for example use 100, 200, and so on.
     * </p>
     * 
     * @return An integer setting that indicates the order in which to run the stateful rule groups in a single
     *         <a>FirewallPolicy</a>. This setting only applies to firewall policies that specify the
     *         <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p>
     *         <p>
     *         Network Firewall evalutes each stateful rule group against a packet starting with the group that has the
     *         lowest priority setting. You must ensure that the priority settings are unique within each policy.
     *         </p>
     *         <p>
     *         You can change the priority settings of your rule groups at any time. To make it easier to insert rule
     *         groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The action that allows the policy owner to override the behavior of the rule group within a policy.
     * </p>
     * 
     * @return The action that allows the policy owner to override the behavior of the rule group within a policy.
     */
    public final StatefulRuleGroupOverride override() {
        return override;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(override());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulRuleGroupReference)) {
            return false;
        }
        StatefulRuleGroupReference other = (StatefulRuleGroupReference) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(priority(), other.priority())
                && Objects.equals(override(), other.override());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatefulRuleGroupReference").add("ResourceArn", resourceArn()).add("Priority", priority())
                .add("Override", override()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Override":
            return Optional.ofNullable(clazz.cast(override()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatefulRuleGroupReference, T> g) {
        return obj -> g.apply((StatefulRuleGroupReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatefulRuleGroupReference> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stateful rule group.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the stateful rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An integer setting that indicates the order in which to run the stateful rule groups in a single
         * <a>FirewallPolicy</a>. This setting only applies to firewall policies that specify the
         * <code>STRICT_ORDER</code> rule order in the stateful engine options settings.
         * </p>
         * <p>
         * Network Firewall evalutes each stateful rule group against a packet starting with the group that has the
         * lowest priority setting. You must ensure that the priority settings are unique within each policy.
         * </p>
         * <p>
         * You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups
         * later, number them so there's a wide range in between, for example use 100, 200, and so on.
         * </p>
         * 
         * @param priority
         *        An integer setting that indicates the order in which to run the stateful rule groups in a single
         *        <a>FirewallPolicy</a>. This setting only applies to firewall policies that specify the
         *        <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p>
         *        <p>
         *        Network Firewall evalutes each stateful rule group against a packet starting with the group that has
         *        the lowest priority setting. You must ensure that the priority settings are unique within each policy.
         *        </p>
         *        <p>
         *        You can change the priority settings of your rule groups at any time. To make it easier to insert rule
         *        groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The action that allows the policy owner to override the behavior of the rule group within a policy.
         * </p>
         * 
         * @param override
         *        The action that allows the policy owner to override the behavior of the rule group within a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder override(StatefulRuleGroupOverride override);

        /**
         * <p>
         * The action that allows the policy owner to override the behavior of the rule group within a policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatefulRuleGroupOverride.Builder}
         * avoiding the need to create one manually via {@link StatefulRuleGroupOverride#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatefulRuleGroupOverride.Builder#build()} is called immediately
         * and its result is passed to {@link #override(StatefulRuleGroupOverride)}.
         * 
         * @param override
         *        a consumer that will call methods on {@link StatefulRuleGroupOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #override(StatefulRuleGroupOverride)
         */
        default Builder override(Consumer<StatefulRuleGroupOverride.Builder> override) {
            return override(StatefulRuleGroupOverride.builder().applyMutation(override).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private Integer priority;

        private StatefulRuleGroupOverride override;

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulRuleGroupReference model) {
            resourceArn(model.resourceArn);
            priority(model.priority);
            override(model.override);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final StatefulRuleGroupOverride.Builder getOverride() {
            return override != null ? override.toBuilder() : null;
        }

        public final void setOverride(StatefulRuleGroupOverride.BuilderImpl override) {
            this.override = override != null ? override.build() : null;
        }

        @Override
        public final Builder override(StatefulRuleGroupOverride override) {
            this.override = override;
            return this;
        }

        @Override
        public StatefulRuleGroupReference build() {
            return new StatefulRuleGroupReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
