/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional options governing how Network Firewall handles the rule group. You can only use these for stateful rule
 * groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatefulRuleOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<StatefulRuleOptions.Builder, StatefulRuleOptions> {
    private static final SdkField<String> RULE_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleOrder").getter(getter(StatefulRuleOptions::ruleOrderAsString)).setter(setter(Builder::ruleOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleOrder;

    private StatefulRuleOptions(BuilderImpl builder) {
        this.ruleOrder = builder.ruleOrder;
    }

    /**
     * <p>
     * Indicates how to manage the order of the rule evaluation for the rule group. <code>DEFAULT_ACTION_ORDER</code> is
     * the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata
     * evaluates them based on certain settings. For more information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     * >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOrder} will
     * return {@link RuleOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOrderAsString}.
     * </p>
     * 
     * @return Indicates how to manage the order of the rule evaluation for the rule group.
     *         <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine
     *         as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     *         >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
     * @see RuleOrder
     */
    public final RuleOrder ruleOrder() {
        return RuleOrder.fromValue(ruleOrder);
    }

    /**
     * <p>
     * Indicates how to manage the order of the rule evaluation for the rule group. <code>DEFAULT_ACTION_ORDER</code> is
     * the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata
     * evaluates them based on certain settings. For more information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     * >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOrder} will
     * return {@link RuleOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOrderAsString}.
     * </p>
     * 
     * @return Indicates how to manage the order of the rule evaluation for the rule group.
     *         <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine
     *         as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     *         >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
     * @see RuleOrder
     */
    public final String ruleOrderAsString() {
        return ruleOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulRuleOptions)) {
            return false;
        }
        StatefulRuleOptions other = (StatefulRuleOptions) obj;
        return Objects.equals(ruleOrderAsString(), other.ruleOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatefulRuleOptions").add("RuleOrder", ruleOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleOrder":
            return Optional.ofNullable(clazz.cast(ruleOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatefulRuleOptions, T> g) {
        return obj -> g.apply((StatefulRuleOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatefulRuleOptions> {
        /**
         * <p>
         * Indicates how to manage the order of the rule evaluation for the rule group.
         * <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as
         * Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         * >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param ruleOrder
         *        Indicates how to manage the order of the rule evaluation for the rule group.
         *        <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule
         *        engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         *        >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
         * @see RuleOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOrder
         */
        Builder ruleOrder(String ruleOrder);

        /**
         * <p>
         * Indicates how to manage the order of the rule evaluation for the rule group.
         * <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as
         * Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         * >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param ruleOrder
         *        Indicates how to manage the order of the rule evaluation for the rule group.
         *        <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule
         *        engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         *        >Evaluation order for stateful rules</a> in the <i>AWS Network Firewall Developer Guide</i>.
         * @see RuleOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOrder
         */
        Builder ruleOrder(RuleOrder ruleOrder);
    }

    static final class BuilderImpl implements Builder {
        private String ruleOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulRuleOptions model) {
            ruleOrder(model.ruleOrder);
        }

        public final String getRuleOrder() {
            return ruleOrder;
        }

        public final void setRuleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        @Override
        public final Builder ruleOrder(RuleOrder ruleOrder) {
            this.ruleOrder(ruleOrder == null ? null : ruleOrder.toString());
            return this;
        }

        @Override
        public StatefulRuleOptions build() {
            return new StatefulRuleOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
