/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.InsufficientCapacityException;
import software.amazon.awssdk.services.networkfirewall.model.InternalServerErrorException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidOperationException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidRequestException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidResourcePolicyException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidTokenException;
import software.amazon.awssdk.services.networkfirewall.model.LimitExceededException;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationPermissionException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkfirewall.model.ResourceOwnerCheckException;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ThrottlingException;
import software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupMetadataRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DisassociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallPoliciesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDeleteProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDescriptionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateSubnetChangeProtectionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultNetworkFirewallClient
implements NetworkFirewallClient {
    private static final Logger log = Logger.loggerFor(DefaultNetworkFirewallClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNetworkFirewallClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "network-firewall";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateFirewallPolicyResponse associateFirewallPolicy(AssociateFirewallPolicyRequest associateFirewallPolicyRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFirewallPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, associateFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFirewallPolicy");
            AssociateFirewallPolicyResponse associateFirewallPolicyResponse = (AssociateFirewallPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFirewallPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateFirewallPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateFirewallPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$associateFirewallPolicy$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateSubnetsResponse associateSubnets(AssociateSubnetsRequest associateSubnetsRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSubnetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, associateSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSubnets");
            AssociateSubnetsResponse associateSubnetsResponse = (AssociateSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateSubnetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateSubnetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateSubnetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$associateSubnets$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFirewallResponse createFirewall(CreateFirewallRequest createFirewallRequest) throws InvalidRequestException, LimitExceededException, InternalServerErrorException, ThrottlingException, InsufficientCapacityException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFirewallResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, createFirewallRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFirewall");
            CreateFirewallResponse createFirewallResponse = (CreateFirewallResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFirewall").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFirewallRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFirewallRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFirewallResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$createFirewall$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFirewallPolicyResponse createFirewallPolicy(CreateFirewallPolicyRequest createFirewallPolicyRequest) throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFirewallPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, createFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFirewallPolicy");
            CreateFirewallPolicyResponse createFirewallPolicyResponse = (CreateFirewallPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFirewallPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFirewallPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFirewallPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$createFirewallPolicy$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, createRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRuleGroup");
            CreateRuleGroupResponse createRuleGroupResponse = (CreateRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$createRuleGroup$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFirewallResponse deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, UnsupportedOperationException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFirewallResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, deleteFirewallRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFirewall");
            DeleteFirewallResponse deleteFirewallResponse = (DeleteFirewallResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFirewall").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFirewallRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFirewallRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFirewallResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$deleteFirewall$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFirewallPolicyResponse deleteFirewallPolicy(DeleteFirewallPolicyRequest deleteFirewallPolicyRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException, UnsupportedOperationException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFirewallPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, deleteFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFirewallPolicy");
            DeleteFirewallPolicyResponse deleteFirewallPolicyResponse = (DeleteFirewallPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFirewallPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFirewallPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFirewallPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$deleteFirewallPolicy$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$deleteResourcePolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException, UnsupportedOperationException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, deleteRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRuleGroup");
            DeleteRuleGroupResponse deleteRuleGroupResponse = (DeleteRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$deleteRuleGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFirewallResponse describeFirewall(DescribeFirewallRequest describeFirewallRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFirewallResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, describeFirewallRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFirewall");
            DescribeFirewallResponse describeFirewallResponse = (DescribeFirewallResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFirewall").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFirewallRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFirewallRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFirewallResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$describeFirewall$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFirewallPolicyResponse describeFirewallPolicy(DescribeFirewallPolicyRequest describeFirewallPolicyRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFirewallPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, describeFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFirewallPolicy");
            DescribeFirewallPolicyResponse describeFirewallPolicyResponse = (DescribeFirewallPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFirewallPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFirewallPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFirewallPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$describeFirewallPolicy$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoggingConfigurationResponse describeLoggingConfiguration(DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLoggingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, describeLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoggingConfiguration");
            DescribeLoggingConfigurationResponse describeLoggingConfigurationResponse = (DescribeLoggingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoggingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLoggingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$describeLoggingConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, describeResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicy");
            DescribeResourcePolicyResponse describeResourcePolicyResponse = (DescribeResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$describeResourcePolicy$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRuleGroupResponse describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, describeRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRuleGroup");
            DescribeRuleGroupResponse describeRuleGroupResponse = (DescribeRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$describeRuleGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRuleGroupMetadataResponse describeRuleGroupMetadata(DescribeRuleGroupMetadataRequest describeRuleGroupMetadataRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleGroupMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, describeRuleGroupMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRuleGroupMetadata");
            DescribeRuleGroupMetadataResponse describeRuleGroupMetadataResponse = (DescribeRuleGroupMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRuleGroupMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuleGroupMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRuleGroupMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRuleGroupMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$describeRuleGroupMetadata$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateSubnetsResponse disassociateSubnets(DisassociateSubnetsRequest disassociateSubnetsRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSubnetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, disassociateSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSubnets");
            DisassociateSubnetsResponse disassociateSubnetsResponse = (DisassociateSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateSubnetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateSubnetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateSubnetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$disassociateSubnets$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFirewallPoliciesResponse listFirewallPolicies(ListFirewallPoliciesRequest listFirewallPoliciesRequest) throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFirewallPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, listFirewallPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFirewallPolicies");
            ListFirewallPoliciesResponse listFirewallPoliciesResponse = (ListFirewallPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFirewallPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFirewallPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFirewallPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFirewallPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$listFirewallPolicies$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFirewallPoliciesIterable listFirewallPoliciesPaginator(ListFirewallPoliciesRequest listFirewallPoliciesRequest) throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListFirewallPoliciesIterable(this, this.applyPaginatorUserAgent(listFirewallPoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFirewallsResponse listFirewalls(ListFirewallsRequest listFirewallsRequest) throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFirewallsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, listFirewallsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFirewalls");
            ListFirewallsResponse listFirewallsResponse = (ListFirewallsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFirewalls").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFirewallsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFirewallsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFirewallsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$listFirewalls$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFirewallsIterable listFirewallsPaginator(ListFirewallsRequest listFirewallsRequest) throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListFirewallsIterable(this, this.applyPaginatorUserAgent(listFirewallsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, listRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleGroups");
            ListRuleGroupsResponse listRuleGroupsResponse = (ListRuleGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRuleGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRuleGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$listRuleGroups$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRuleGroupsIterable listRuleGroupsPaginator(ListRuleGroupsRequest listRuleGroupsRequest) throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListRuleGroupsIterable(this, this.applyPaginatorUserAgent(listRuleGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$listTagsForResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$putResourcePolicy$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$tagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$untagResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallDeleteProtectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallDeleteProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallDeleteProtection");
            UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtectionResponse = (UpdateFirewallDeleteProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallDeleteProtection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFirewallDeleteProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFirewallDeleteProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFirewallDeleteProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateFirewallDeleteProtection$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFirewallDescriptionResponse updateFirewallDescription(UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallDescriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallDescription");
            UpdateFirewallDescriptionResponse updateFirewallDescriptionResponse = (UpdateFirewallDescriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallDescription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFirewallDescriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFirewallDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFirewallDescriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateFirewallDescription$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFirewallPolicyResponse updateFirewallPolicy(UpdateFirewallPolicyRequest updateFirewallPolicyRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException, InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallPolicy");
            UpdateFirewallPolicyResponse updateFirewallPolicyResponse = (UpdateFirewallPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFirewallPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFirewallPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFirewallPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateFirewallPolicy$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFirewallPolicyChangeProtectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateFirewallPolicyChangeProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFirewallPolicyChangeProtection");
            UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtectionResponse = (UpdateFirewallPolicyChangeProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFirewallPolicyChangeProtection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFirewallPolicyChangeProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFirewallPolicyChangeProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFirewallPolicyChangeProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateFirewallPolicyChangeProtection$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLoggingConfigurationResponse updateLoggingConfiguration(UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, LogDestinationPermissionException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLoggingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLoggingConfiguration");
            UpdateLoggingConfigurationResponse updateLoggingConfigurationResponse = (UpdateLoggingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLoggingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLoggingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLoggingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateLoggingConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalServerErrorException, InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRuleGroup");
            UpdateRuleGroupResponse updateRuleGroupResponse = (UpdateRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateRuleGroup$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubnetChangeProtectionResponse updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubnetChangeProtectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultNetworkFirewallClient.resolveMetricPublishers(this.clientConfiguration, updateSubnetChangeProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubnetChangeProtection");
            UpdateSubnetChangeProtectionResponse updateSubnetChangeProtectionResponse = (UpdateSubnetChangeProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubnetChangeProtection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSubnetChangeProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubnetChangeProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubnetChangeProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNetworkFirewallClient.lambda$updateSubnetChangeProtection$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NetworkFirewallException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOperationException").exceptionBuilderSupplier(InvalidOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").exceptionBuilderSupplier(LogDestinationPermissionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").exceptionBuilderSupplier(InsufficientCapacityException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTokenException").exceptionBuilderSupplier(InvalidTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends NetworkFirewallRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.172").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NetworkFirewallRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateSubnetChangeProtection$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRuleGroup$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLoggingConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallPolicyChangeProtection$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallPolicy$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallDescription$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFirewallDeleteProtection$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleGroups$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFirewalls$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFirewallPolicies$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateSubnets$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRuleGroupMetadata$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRuleGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoggingConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFirewallPolicy$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFirewall$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRuleGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFirewallPolicy$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFirewall$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRuleGroup$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFirewallPolicy$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFirewall$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSubnets$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFirewallPolicy$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

