/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupType;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRuleGroupMetadataResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, DescribeRuleGroupMetadataResponse> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(DescribeRuleGroupMetadataResponse.getter(DescribeRuleGroupMetadataResponse::ruleGroupArn)).setter(DescribeRuleGroupMetadataResponse.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()}).build();
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupName").getter(DescribeRuleGroupMetadataResponse.getter(DescribeRuleGroupMetadataResponse::ruleGroupName)).setter(DescribeRuleGroupMetadataResponse.setter(Builder::ruleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeRuleGroupMetadataResponse.getter(DescribeRuleGroupMetadataResponse::description)).setter(DescribeRuleGroupMetadataResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeRuleGroupMetadataResponse.getter(DescribeRuleGroupMetadataResponse::typeAsString)).setter(DescribeRuleGroupMetadataResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Capacity").getter(DescribeRuleGroupMetadataResponse.getter(DescribeRuleGroupMetadataResponse::capacity)).setter(DescribeRuleGroupMetadataResponse.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<StatefulRuleOptions> STATEFUL_RULE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatefulRuleOptions").getter(DescribeRuleGroupMetadataResponse.getter(DescribeRuleGroupMetadataResponse::statefulRuleOptions)).setter(DescribeRuleGroupMetadataResponse.setter(Builder::statefulRuleOptions)).constructor(StatefulRuleOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD, RULE_GROUP_NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CAPACITY_FIELD, STATEFUL_RULE_OPTIONS_FIELD));
    private final String ruleGroupArn;
    private final String ruleGroupName;
    private final String description;
    private final String type;
    private final Integer capacity;
    private final StatefulRuleOptions statefulRuleOptions;

    private DescribeRuleGroupMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupName = builder.ruleGroupName;
        this.description = builder.description;
        this.type = builder.type;
        this.capacity = builder.capacity;
        this.statefulRuleOptions = builder.statefulRuleOptions;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final String ruleGroupName() {
        return this.ruleGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final RuleGroupType type() {
        return RuleGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public final StatefulRuleOptions statefulRuleOptions() {
        return this.statefulRuleOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.statefulRuleOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuleGroupMetadataResponse)) {
            return false;
        }
        DescribeRuleGroupMetadataResponse other = (DescribeRuleGroupMetadataResponse)((Object)obj);
        return Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(this.ruleGroupName(), other.ruleGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.statefulRuleOptions(), other.statefulRuleOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRuleGroupMetadataResponse").add("RuleGroupArn", (Object)this.ruleGroupArn()).add("RuleGroupName", (Object)this.ruleGroupName()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("Capacity", (Object)this.capacity()).add("StatefulRuleOptions", (Object)this.statefulRuleOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "RuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "StatefulRuleOptions": {
                return Optional.ofNullable(clazz.cast(this.statefulRuleOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuleGroupMetadataResponse, T> g) {
        return obj -> g.apply((DescribeRuleGroupMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String ruleGroupArn;
        private String ruleGroupName;
        private String description;
        private String type;
        private Integer capacity;
        private StatefulRuleOptions statefulRuleOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuleGroupMetadataResponse model) {
            super(model);
            this.ruleGroupArn(model.ruleGroupArn);
            this.ruleGroupName(model.ruleGroupName);
            this.description(model.description);
            this.type(model.type);
            this.capacity(model.capacity);
            this.statefulRuleOptions(model.statefulRuleOptions);
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupName() {
            return this.ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final StatefulRuleOptions.Builder getStatefulRuleOptions() {
            return this.statefulRuleOptions != null ? this.statefulRuleOptions.toBuilder() : null;
        }

        public final void setStatefulRuleOptions(StatefulRuleOptions.BuilderImpl statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions != null ? statefulRuleOptions.build() : null;
        }

        @Override
        public final Builder statefulRuleOptions(StatefulRuleOptions statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions;
            return this;
        }

        @Override
        public DescribeRuleGroupMetadataResponse build() {
            return new DescribeRuleGroupMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRuleGroupMetadataResponse> {
        public Builder ruleGroupArn(String var1);

        public Builder ruleGroupName(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(RuleGroupType var1);

        public Builder capacity(Integer var1);

        public Builder statefulRuleOptions(StatefulRuleOptions var1);

        default public Builder statefulRuleOptions(Consumer<StatefulRuleOptions.Builder> statefulRuleOptions) {
            return this.statefulRuleOptions((StatefulRuleOptions)((StatefulRuleOptions.Builder)StatefulRuleOptions.builder().applyMutation(statefulRuleOptions)).build());
        }
    }
}

