/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for the handling of the stateful rule groups in a firewall policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatefulEngineOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<StatefulEngineOptions.Builder, StatefulEngineOptions> {
    private static final SdkField<String> RULE_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleOrder").getter(getter(StatefulEngineOptions::ruleOrderAsString)).setter(setter(Builder::ruleOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()).build();

    private static final SdkField<String> STREAM_EXCEPTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamExceptionPolicy").getter(getter(StatefulEngineOptions::streamExceptionPolicyAsString))
            .setter(setter(Builder::streamExceptionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamExceptionPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ORDER_FIELD,
            STREAM_EXCEPTION_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleOrder;

    private final String streamExceptionPolicy;

    private StatefulEngineOptions(BuilderImpl builder) {
        this.ruleOrder = builder.ruleOrder;
        this.streamExceptionPolicy = builder.streamExceptionPolicy;
    }

    /**
     * <p>
     * Indicates how to manage the order of stateful rule evaluation for the policy. <code>DEFAULT_ACTION_ORDER</code>
     * is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and
     * Suricata evaluates them based on certain settings. For more information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOrder} will
     * return {@link RuleOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOrderAsString}.
     * </p>
     * 
     * @return Indicates how to manage the order of stateful rule evaluation for the policy.
     *         <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine
     *         as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     *         >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
     * @see RuleOrder
     */
    public final RuleOrder ruleOrder() {
        return RuleOrder.fromValue(ruleOrder);
    }

    /**
     * <p>
     * Indicates how to manage the order of stateful rule evaluation for the policy. <code>DEFAULT_ACTION_ORDER</code>
     * is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and
     * Suricata evaluates them based on certain settings. For more information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOrder} will
     * return {@link RuleOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOrderAsString}.
     * </p>
     * 
     * @return Indicates how to manage the order of stateful rule evaluation for the policy.
     *         <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine
     *         as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     *         >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
     * @see RuleOrder
     */
    public final String ruleOrderAsString() {
        return ruleOrder;
    }

    /**
     * <p>
     * Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections
     * can break due to disruptions in external networks or within the firewall itself.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is
     * the default behavior.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without context from
     * traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you
     * have a stateful rule to <code>drop http</code> traffic, Network Firewall won't match the traffic for this rule
     * because the service won't have the context from session initialization defining the application layer protocol as
     * HTTP. However, this behavior is rule dependent—a TCP-layer rule using a <code>flow:stateless</code> rule would
     * still match, as would the <code>aws:drop_strict</code> default action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamExceptionPolicy} will return {@link StreamExceptionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamExceptionPolicyAsString}.
     * </p>
     * 
     * @return Configures how Network Firewall processes traffic when a network connection breaks midstream. Network
     *         connections can break due to disruptions in external networks or within the firewall itself.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall.
     *         This is the default behavior.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without
     *         context from traffic before the break. This impacts the behavior of rules that depend on this context.
     *         For example, if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won't match
     *         the traffic for this rule because the service won't have the context from session initialization defining
     *         the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a
     *         <code>flow:stateless</code> rule would still match, as would the <code>aws:drop_strict</code> default
     *         action.
     *         </p>
     *         </li>
     * @see StreamExceptionPolicy
     */
    public final StreamExceptionPolicy streamExceptionPolicy() {
        return StreamExceptionPolicy.fromValue(streamExceptionPolicy);
    }

    /**
     * <p>
     * Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections
     * can break due to disruptions in external networks or within the firewall itself.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is
     * the default behavior.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without context from
     * traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you
     * have a stateful rule to <code>drop http</code> traffic, Network Firewall won't match the traffic for this rule
     * because the service won't have the context from session initialization defining the application layer protocol as
     * HTTP. However, this behavior is rule dependent—a TCP-layer rule using a <code>flow:stateless</code> rule would
     * still match, as would the <code>aws:drop_strict</code> default action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamExceptionPolicy} will return {@link StreamExceptionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamExceptionPolicyAsString}.
     * </p>
     * 
     * @return Configures how Network Firewall processes traffic when a network connection breaks midstream. Network
     *         connections can break due to disruptions in external networks or within the firewall itself.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall.
     *         This is the default behavior.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without
     *         context from traffic before the break. This impacts the behavior of rules that depend on this context.
     *         For example, if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won't match
     *         the traffic for this rule because the service won't have the context from session initialization defining
     *         the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a
     *         <code>flow:stateless</code> rule would still match, as would the <code>aws:drop_strict</code> default
     *         action.
     *         </p>
     *         </li>
     * @see StreamExceptionPolicy
     */
    public final String streamExceptionPolicyAsString() {
        return streamExceptionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamExceptionPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulEngineOptions)) {
            return false;
        }
        StatefulEngineOptions other = (StatefulEngineOptions) obj;
        return Objects.equals(ruleOrderAsString(), other.ruleOrderAsString())
                && Objects.equals(streamExceptionPolicyAsString(), other.streamExceptionPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatefulEngineOptions").add("RuleOrder", ruleOrderAsString())
                .add("StreamExceptionPolicy", streamExceptionPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleOrder":
            return Optional.ofNullable(clazz.cast(ruleOrderAsString()));
        case "StreamExceptionPolicy":
            return Optional.ofNullable(clazz.cast(streamExceptionPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatefulEngineOptions, T> g) {
        return obj -> g.apply((StatefulEngineOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatefulEngineOptions> {
        /**
         * <p>
         * Indicates how to manage the order of stateful rule evaluation for the policy.
         * <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as
         * Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param ruleOrder
         *        Indicates how to manage the order of stateful rule evaluation for the policy.
         *        <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule
         *        engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         *        >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
         * @see RuleOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOrder
         */
        Builder ruleOrder(String ruleOrder);

        /**
         * <p>
         * Indicates how to manage the order of stateful rule evaluation for the policy.
         * <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as
         * Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param ruleOrder
         *        Indicates how to manage the order of stateful rule evaluation for the policy.
         *        <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule
         *        engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         *        >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
         * @see RuleOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOrder
         */
        Builder ruleOrder(RuleOrder ruleOrder);

        /**
         * <p>
         * Configures how Network Firewall processes traffic when a network connection breaks midstream. Network
         * connections can break due to disruptions in external networks or within the firewall itself.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall.
         * This is the default behavior.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without context
         * from traffic before the break. This impacts the behavior of rules that depend on this context. For example,
         * if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won't match the traffic for
         * this rule because the service won't have the context from session initialization defining the application
         * layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a
         * <code>flow:stateless</code> rule would still match, as would the <code>aws:drop_strict</code> default action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamExceptionPolicy
         *        Configures how Network Firewall processes traffic when a network connection breaks midstream. Network
         *        connections can break due to disruptions in external networks or within the firewall itself.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the
         *        firewall. This is the default behavior.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without
         *        context from traffic before the break. This impacts the behavior of rules that depend on this context.
         *        For example, if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won't
         *        match the traffic for this rule because the service won't have the context from session initialization
         *        defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer
         *        rule using a <code>flow:stateless</code> rule would still match, as would the
         *        <code>aws:drop_strict</code> default action.
         *        </p>
         *        </li>
         * @see StreamExceptionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamExceptionPolicy
         */
        Builder streamExceptionPolicy(String streamExceptionPolicy);

        /**
         * <p>
         * Configures how Network Firewall processes traffic when a network connection breaks midstream. Network
         * connections can break due to disruptions in external networks or within the firewall itself.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall.
         * This is the default behavior.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without context
         * from traffic before the break. This impacts the behavior of rules that depend on this context. For example,
         * if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won't match the traffic for
         * this rule because the service won't have the context from session initialization defining the application
         * layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a
         * <code>flow:stateless</code> rule would still match, as would the <code>aws:drop_strict</code> default action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamExceptionPolicy
         *        Configures how Network Firewall processes traffic when a network connection breaks midstream. Network
         *        connections can break due to disruptions in external networks or within the firewall itself.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the
         *        firewall. This is the default behavior.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without
         *        context from traffic before the break. This impacts the behavior of rules that depend on this context.
         *        For example, if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won't
         *        match the traffic for this rule because the service won't have the context from session initialization
         *        defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer
         *        rule using a <code>flow:stateless</code> rule would still match, as would the
         *        <code>aws:drop_strict</code> default action.
         *        </p>
         *        </li>
         * @see StreamExceptionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamExceptionPolicy
         */
        Builder streamExceptionPolicy(StreamExceptionPolicy streamExceptionPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String ruleOrder;

        private String streamExceptionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulEngineOptions model) {
            ruleOrder(model.ruleOrder);
            streamExceptionPolicy(model.streamExceptionPolicy);
        }

        public final String getRuleOrder() {
            return ruleOrder;
        }

        public final void setRuleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        @Override
        public final Builder ruleOrder(RuleOrder ruleOrder) {
            this.ruleOrder(ruleOrder == null ? null : ruleOrder.toString());
            return this;
        }

        public final String getStreamExceptionPolicy() {
            return streamExceptionPolicy;
        }

        public final void setStreamExceptionPolicy(String streamExceptionPolicy) {
            this.streamExceptionPolicy = streamExceptionPolicy;
        }

        @Override
        public final Builder streamExceptionPolicy(String streamExceptionPolicy) {
            this.streamExceptionPolicy = streamExceptionPolicy;
            return this;
        }

        @Override
        public final Builder streamExceptionPolicy(StreamExceptionPolicy streamExceptionPolicy) {
            this.streamExceptionPolicy(streamExceptionPolicy == null ? null : streamExceptionPolicy.toString());
            return this;
        }

        @Override
        public StatefulEngineOptions build() {
            return new StatefulEngineOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
