/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMapping;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateSubnetsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, DisassociateSubnetsResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(DisassociateSubnetsResponse.getter(DisassociateSubnetsResponse::firewallArn)).setter(DisassociateSubnetsResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(DisassociateSubnetsResponse.getter(DisassociateSubnetsResponse::firewallName)).setter(DisassociateSubnetsResponse.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetMappings").getter(DisassociateSubnetsResponse.getter(DisassociateSubnetsResponse::subnetMappings)).setter(DisassociateSubnetsResponse.setter(Builder::subnetMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(DisassociateSubnetsResponse.getter(DisassociateSubnetsResponse::updateToken)).setter(DisassociateSubnetsResponse.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, FIREWALL_NAME_FIELD, SUBNET_MAPPINGS_FIELD, UPDATE_TOKEN_FIELD));
    private final String firewallArn;
    private final String firewallName;
    private final List<SubnetMapping> subnetMappings;
    private final String updateToken;

    private DisassociateSubnetsResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.firewallName = builder.firewallName;
        this.subnetMappings = builder.subnetMappings;
        this.updateToken = builder.updateToken;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String firewallName() {
        return this.firewallName;
    }

    public final boolean hasSubnetMappings() {
        return this.subnetMappings != null && !(this.subnetMappings instanceof SdkAutoConstructList);
    }

    public final List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetMappings() ? this.subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSubnetsResponse)) {
            return false;
        }
        DisassociateSubnetsResponse other = (DisassociateSubnetsResponse)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.firewallName(), other.firewallName()) && this.hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(this.subnetMappings(), other.subnetMappings()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateSubnetsResponse").add("FirewallArn", (Object)this.firewallArn()).add("FirewallName", (Object)this.firewallName()).add("SubnetMappings", this.hasSubnetMappings() ? this.subnetMappings() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "SubnetMappings": {
                return Optional.ofNullable(clazz.cast(this.subnetMappings()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateSubnetsResponse, T> g) {
        return obj -> g.apply((DisassociateSubnetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String firewallName;
        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSubnetsResponse model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.firewallName(model.firewallName);
            this.subnetMappings(model.subnetMappings);
            this.updateToken(model.updateToken);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        @Transient
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        @Transient
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final List<SubnetMapping.Builder> getSubnetMappings() {
            List<SubnetMapping.Builder> result = SubnetMappingsCopier.copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        @Transient
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder> ... subnetMappings) {
            this.subnetMappings(Stream.of(subnetMappings).map(c -> (SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        @Transient
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public DisassociateSubnetsResponse build() {
            return new DisassociateSubnetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateSubnetsResponse> {
        public Builder firewallArn(String var1);

        public Builder firewallName(String var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder subnetMappings(Consumer<SubnetMapping.Builder> ... var1);

        public Builder updateToken(String var1);
    }
}

