/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.VariableDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPSet> {
    private static final SdkField<List<String>> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Definition").getter(IPSet.getter(IPSet::definition)).setter(IPSet.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> definition;

    private IPSet(BuilderImpl builder) {
        this.definition = builder.definition;
    }

    public final boolean hasDefinition() {
        return this.definition != null && !(this.definition instanceof SdkAutoConstructList);
    }

    public final List<String> definition() {
        return this.definition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefinition() ? this.definition() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        return this.hasDefinition() == other.hasDefinition() && Objects.equals(this.definition(), other.definition());
    }

    public final String toString() {
        return ToString.builder((String)"IPSet").add("Definition", this.hasDefinition() ? this.definition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSet, T> g) {
        return obj -> g.apply((IPSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> definition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IPSet model) {
            this.definition(model.definition);
        }

        public final Collection<String> getDefinition() {
            if (this.definition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.definition;
        }

        public final void setDefinition(Collection<String> definition) {
            this.definition = VariableDefinitionListCopier.copy(definition);
        }

        @Override
        @Transient
        public final Builder definition(Collection<String> definition) {
            this.definition = VariableDefinitionListCopier.copy(definition);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder definition(String ... definition) {
            this.definition(Arrays.asList(definition));
            return this;
        }

        public IPSet build() {
            return new IPSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPSet> {
        public Builder definition(Collection<String> var1);

        public Builder definition(String ... var1);
    }
}

