/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.CustomAction;
import software.amazon.awssdk.services.networkfirewall.model.CustomActionsCopier;
import software.amazon.awssdk.services.networkfirewall.model.StatelessRule;
import software.amazon.awssdk.services.networkfirewall.model.StatelessRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatelessRulesAndCustomActions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatelessRulesAndCustomActions> {
    private static final SdkField<List<StatelessRule>> STATELESS_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatelessRules").getter(StatelessRulesAndCustomActions.getter(StatelessRulesAndCustomActions::statelessRules)).setter(StatelessRulesAndCustomActions.setter(Builder::statelessRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatelessRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CustomAction>> CUSTOM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomActions").getter(StatelessRulesAndCustomActions.getter(StatelessRulesAndCustomActions::customActions)).setter(StatelessRulesAndCustomActions.setter(Builder::customActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATELESS_RULES_FIELD, CUSTOM_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<StatelessRule> statelessRules;
    private final List<CustomAction> customActions;

    private StatelessRulesAndCustomActions(BuilderImpl builder) {
        this.statelessRules = builder.statelessRules;
        this.customActions = builder.customActions;
    }

    public final boolean hasStatelessRules() {
        return this.statelessRules != null && !(this.statelessRules instanceof SdkAutoConstructList);
    }

    public final List<StatelessRule> statelessRules() {
        return this.statelessRules;
    }

    public final boolean hasCustomActions() {
        return this.customActions != null && !(this.customActions instanceof SdkAutoConstructList);
    }

    public final List<CustomAction> customActions() {
        return this.customActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatelessRules() ? this.statelessRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomActions() ? this.customActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatelessRulesAndCustomActions)) {
            return false;
        }
        StatelessRulesAndCustomActions other = (StatelessRulesAndCustomActions)obj;
        return this.hasStatelessRules() == other.hasStatelessRules() && Objects.equals(this.statelessRules(), other.statelessRules()) && this.hasCustomActions() == other.hasCustomActions() && Objects.equals(this.customActions(), other.customActions());
    }

    public final String toString() {
        return ToString.builder((String)"StatelessRulesAndCustomActions").add("StatelessRules", this.hasStatelessRules() ? this.statelessRules() : null).add("CustomActions", this.hasCustomActions() ? this.customActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatelessRules": {
                return Optional.ofNullable(clazz.cast(this.statelessRules()));
            }
            case "CustomActions": {
                return Optional.ofNullable(clazz.cast(this.customActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatelessRulesAndCustomActions, T> g) {
        return obj -> g.apply((StatelessRulesAndCustomActions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StatelessRule> statelessRules = DefaultSdkAutoConstructList.getInstance();
        private List<CustomAction> customActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatelessRulesAndCustomActions model) {
            this.statelessRules(model.statelessRules);
            this.customActions(model.customActions);
        }

        public final List<StatelessRule.Builder> getStatelessRules() {
            List<StatelessRule.Builder> result = StatelessRulesCopier.copyToBuilder(this.statelessRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRules(Collection<StatelessRule.BuilderImpl> statelessRules) {
            this.statelessRules = StatelessRulesCopier.copyFromBuilder(statelessRules);
        }

        @Override
        @Transient
        public final Builder statelessRules(Collection<StatelessRule> statelessRules) {
            this.statelessRules = StatelessRulesCopier.copy(statelessRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessRules(StatelessRule ... statelessRules) {
            this.statelessRules(Arrays.asList(statelessRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statelessRules(Consumer<StatelessRule.Builder> ... statelessRules) {
            this.statelessRules(Stream.of(statelessRules).map(c -> (StatelessRule)((StatelessRule.Builder)StatelessRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CustomAction.Builder> getCustomActions() {
            List<CustomAction.Builder> result = CustomActionsCopier.copyToBuilder(this.customActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomActions(Collection<CustomAction.BuilderImpl> customActions) {
            this.customActions = CustomActionsCopier.copyFromBuilder(customActions);
        }

        @Override
        @Transient
        public final Builder customActions(Collection<CustomAction> customActions) {
            this.customActions = CustomActionsCopier.copy(customActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customActions(CustomAction ... customActions) {
            this.customActions(Arrays.asList(customActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customActions(Consumer<CustomAction.Builder> ... customActions) {
            this.customActions(Stream.of(customActions).map(c -> (CustomAction)((CustomAction.Builder)CustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StatelessRulesAndCustomActions build() {
            return new StatelessRulesAndCustomActions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatelessRulesAndCustomActions> {
        public Builder statelessRules(Collection<StatelessRule> var1);

        public Builder statelessRules(StatelessRule ... var1);

        public Builder statelessRules(Consumer<StatelessRule.Builder> ... var1);

        public Builder customActions(Collection<CustomAction> var1);

        public Builder customActions(CustomAction ... var1);

        public Builder customActions(Consumer<CustomAction.Builder> ... var1);
    }
}

