/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.RuleVariables;
import software.amazon.awssdk.services.networkfirewall.model.RulesSource;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroup> {
    private static final SdkField<RuleVariables> RULE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleVariables").getter(RuleGroup.getter(RuleGroup::ruleVariables)).setter(RuleGroup.setter(Builder::ruleVariables)).constructor(RuleVariables::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVariables").build()}).build();
    private static final SdkField<RulesSource> RULES_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RulesSource").getter(RuleGroup.getter(RuleGroup::rulesSource)).setter(RuleGroup.setter(Builder::rulesSource)).constructor(RulesSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSource").build()}).build();
    private static final SdkField<StatefulRuleOptions> STATEFUL_RULE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatefulRuleOptions").getter(RuleGroup.getter(RuleGroup::statefulRuleOptions)).setter(RuleGroup.setter(Builder::statefulRuleOptions)).constructor(StatefulRuleOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_VARIABLES_FIELD, RULES_SOURCE_FIELD, STATEFUL_RULE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final RuleVariables ruleVariables;
    private final RulesSource rulesSource;
    private final StatefulRuleOptions statefulRuleOptions;

    private RuleGroup(BuilderImpl builder) {
        this.ruleVariables = builder.ruleVariables;
        this.rulesSource = builder.rulesSource;
        this.statefulRuleOptions = builder.statefulRuleOptions;
    }

    public final RuleVariables ruleVariables() {
        return this.ruleVariables;
    }

    public final RulesSource rulesSource() {
        return this.rulesSource;
    }

    public final StatefulRuleOptions statefulRuleOptions() {
        return this.statefulRuleOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.statefulRuleOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroup)) {
            return false;
        }
        RuleGroup other = (RuleGroup)obj;
        return Objects.equals(this.ruleVariables(), other.ruleVariables()) && Objects.equals(this.rulesSource(), other.rulesSource()) && Objects.equals(this.statefulRuleOptions(), other.statefulRuleOptions());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroup").add("RuleVariables", (Object)this.ruleVariables()).add("RulesSource", (Object)this.rulesSource()).add("StatefulRuleOptions", (Object)this.statefulRuleOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleVariables": {
                return Optional.ofNullable(clazz.cast(this.ruleVariables()));
            }
            case "RulesSource": {
                return Optional.ofNullable(clazz.cast(this.rulesSource()));
            }
            case "StatefulRuleOptions": {
                return Optional.ofNullable(clazz.cast(this.statefulRuleOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroup, T> g) {
        return obj -> g.apply((RuleGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RuleVariables ruleVariables;
        private RulesSource rulesSource;
        private StatefulRuleOptions statefulRuleOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroup model) {
            this.ruleVariables(model.ruleVariables);
            this.rulesSource(model.rulesSource);
            this.statefulRuleOptions(model.statefulRuleOptions);
        }

        public final RuleVariables.Builder getRuleVariables() {
            return this.ruleVariables != null ? this.ruleVariables.toBuilder() : null;
        }

        public final void setRuleVariables(RuleVariables.BuilderImpl ruleVariables) {
            this.ruleVariables = ruleVariables != null ? ruleVariables.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleVariables(RuleVariables ruleVariables) {
            this.ruleVariables = ruleVariables;
            return this;
        }

        public final RulesSource.Builder getRulesSource() {
            return this.rulesSource != null ? this.rulesSource.toBuilder() : null;
        }

        public final void setRulesSource(RulesSource.BuilderImpl rulesSource) {
            this.rulesSource = rulesSource != null ? rulesSource.build() : null;
        }

        @Override
        @Transient
        public final Builder rulesSource(RulesSource rulesSource) {
            this.rulesSource = rulesSource;
            return this;
        }

        public final StatefulRuleOptions.Builder getStatefulRuleOptions() {
            return this.statefulRuleOptions != null ? this.statefulRuleOptions.toBuilder() : null;
        }

        public final void setStatefulRuleOptions(StatefulRuleOptions.BuilderImpl statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions != null ? statefulRuleOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder statefulRuleOptions(StatefulRuleOptions statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions;
            return this;
        }

        public RuleGroup build() {
            return new RuleGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroup> {
        public Builder ruleVariables(RuleVariables var1);

        default public Builder ruleVariables(Consumer<RuleVariables.Builder> ruleVariables) {
            return this.ruleVariables((RuleVariables)((RuleVariables.Builder)RuleVariables.builder().applyMutation(ruleVariables)).build());
        }

        public Builder rulesSource(RulesSource var1);

        default public Builder rulesSource(Consumer<RulesSource.Builder> rulesSource) {
            return this.rulesSource((RulesSource)((RulesSource.Builder)RulesSource.builder().applyMutation(rulesSource)).build());
        }

        public Builder statefulRuleOptions(StatefulRuleOptions var1);

        default public Builder statefulRuleOptions(Consumer<StatefulRuleOptions.Builder> statefulRuleOptions) {
            return this.statefulRuleOptions((StatefulRuleOptions)((StatefulRuleOptions.Builder)StatefulRuleOptions.builder().applyMutation(statefulRuleOptions)).build());
        }
    }
}

