/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ResourceStatus;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupType;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupResponse> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupArn)).setter(RuleGroupResponse.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()}).build();
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupName").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupName)).setter(RuleGroupResponse.setter(Builder::ruleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()}).build();
    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupId").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupId)).setter(RuleGroupResponse.setter(Builder::ruleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RuleGroupResponse.getter(RuleGroupResponse::description)).setter(RuleGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RuleGroupResponse.getter(RuleGroupResponse::typeAsString)).setter(RuleGroupResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Capacity").getter(RuleGroupResponse.getter(RuleGroupResponse::capacity)).setter(RuleGroupResponse.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<String> RULE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupStatus").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupStatusAsString)).setter(RuleGroupResponse.setter(Builder::ruleGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RuleGroupResponse.getter(RuleGroupResponse::tags)).setter(RuleGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConsumedCapacity").getter(RuleGroupResponse.getter(RuleGroupResponse::consumedCapacity)).setter(RuleGroupResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssociations").getter(RuleGroupResponse.getter(RuleGroupResponse::numberOfAssociations)).setter(RuleGroupResponse.setter(Builder::numberOfAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD, RULE_GROUP_NAME_FIELD, RULE_GROUP_ID_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CAPACITY_FIELD, RULE_GROUP_STATUS_FIELD, TAGS_FIELD, CONSUMED_CAPACITY_FIELD, NUMBER_OF_ASSOCIATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleGroupArn;
    private final String ruleGroupName;
    private final String ruleGroupId;
    private final String description;
    private final String type;
    private final Integer capacity;
    private final String ruleGroupStatus;
    private final List<Tag> tags;
    private final Integer consumedCapacity;
    private final Integer numberOfAssociations;

    private RuleGroupResponse(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroupId = builder.ruleGroupId;
        this.description = builder.description;
        this.type = builder.type;
        this.capacity = builder.capacity;
        this.ruleGroupStatus = builder.ruleGroupStatus;
        this.tags = builder.tags;
        this.consumedCapacity = builder.consumedCapacity;
        this.numberOfAssociations = builder.numberOfAssociations;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final String ruleGroupName() {
        return this.ruleGroupName;
    }

    public final String ruleGroupId() {
        return this.ruleGroupId;
    }

    public final String description() {
        return this.description;
    }

    public final RuleGroupType type() {
        return RuleGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public final ResourceStatus ruleGroupStatus() {
        return ResourceStatus.fromValue(this.ruleGroupStatus);
    }

    public final String ruleGroupStatusAsString() {
        return this.ruleGroupStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Integer consumedCapacity() {
        return this.consumedCapacity;
    }

    public final Integer numberOfAssociations() {
        return this.numberOfAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupResponse)) {
            return false;
        }
        RuleGroupResponse other = (RuleGroupResponse)obj;
        return Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(this.ruleGroupName(), other.ruleGroupName()) && Objects.equals(this.ruleGroupId(), other.ruleGroupId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.ruleGroupStatusAsString(), other.ruleGroupStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && Objects.equals(this.numberOfAssociations(), other.numberOfAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupResponse").add("RuleGroupArn", (Object)this.ruleGroupArn()).add("RuleGroupName", (Object)this.ruleGroupName()).add("RuleGroupId", (Object)this.ruleGroupId()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("Capacity", (Object)this.capacity()).add("RuleGroupStatus", (Object)this.ruleGroupStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ConsumedCapacity", (Object)this.consumedCapacity()).add("NumberOfAssociations", (Object)this.numberOfAssociations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "RuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupName()));
            }
            case "RuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "RuleGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupStatusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "NumberOfAssociations": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupResponse, T> g) {
        return obj -> g.apply((RuleGroupResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleGroupArn;
        private String ruleGroupName;
        private String ruleGroupId;
        private String description;
        private String type;
        private Integer capacity;
        private String ruleGroupStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer consumedCapacity;
        private Integer numberOfAssociations;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupResponse model) {
            this.ruleGroupArn(model.ruleGroupArn);
            this.ruleGroupName(model.ruleGroupName);
            this.ruleGroupId(model.ruleGroupId);
            this.description(model.description);
            this.type(model.type);
            this.capacity(model.capacity);
            this.ruleGroupStatus(model.ruleGroupStatus);
            this.tags(model.tags);
            this.consumedCapacity(model.consumedCapacity);
            this.numberOfAssociations(model.numberOfAssociations);
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        @Transient
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupName() {
            return this.ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        @Transient
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getRuleGroupId() {
            return this.ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        @Transient
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        @Transient
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getRuleGroupStatus() {
            return this.ruleGroupStatus;
        }

        public final void setRuleGroupStatus(String ruleGroupStatus) {
            this.ruleGroupStatus = ruleGroupStatus;
        }

        @Override
        @Transient
        public final Builder ruleGroupStatus(String ruleGroupStatus) {
            this.ruleGroupStatus = ruleGroupStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder ruleGroupStatus(ResourceStatus ruleGroupStatus) {
            this.ruleGroupStatus(ruleGroupStatus == null ? null : ruleGroupStatus.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public final void setConsumedCapacity(Integer consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        @Override
        @Transient
        public final Builder consumedCapacity(Integer consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final Integer getNumberOfAssociations() {
            return this.numberOfAssociations;
        }

        public final void setNumberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
        }

        @Override
        @Transient
        public final Builder numberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
            return this;
        }

        public RuleGroupResponse build() {
            return new RuleGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupResponse> {
        public Builder ruleGroupArn(String var1);

        public Builder ruleGroupName(String var1);

        public Builder ruleGroupId(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(RuleGroupType var1);

        public Builder capacity(Integer var1);

        public Builder ruleGroupStatus(String var1);

        public Builder ruleGroupStatus(ResourceStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder consumedCapacity(Integer var1);

        public Builder numberOfAssociations(Integer var1);
    }
}

