/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.networkfirewall.DefaultNetworkFirewallBaseClientBuilder;
import software.amazon.awssdk.services.networkfirewall.DefaultNetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClientBuilder;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallServiceClientConfiguration;
import software.amazon.awssdk.services.networkfirewall.endpoints.NetworkFirewallEndpointProvider;

@SdkInternalApi
final class DefaultNetworkFirewallClientBuilder
extends DefaultNetworkFirewallBaseClientBuilder<NetworkFirewallClientBuilder, NetworkFirewallClient>
implements NetworkFirewallClientBuilder {
    DefaultNetworkFirewallClientBuilder() {
    }

    @Override
    public DefaultNetworkFirewallClientBuilder endpointProvider(NetworkFirewallEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NetworkFirewallClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultNetworkFirewallClientBuilder.validateClientOptions(clientConfiguration);
        NetworkFirewallServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultNetworkFirewallClient client = new DefaultNetworkFirewallClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private NetworkFirewallServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return NetworkFirewallServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

