/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRuleGroupMetadataResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeRuleGroupMetadataResponse.Builder, DescribeRuleGroupMetadataResponse> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn").getter(getter(DescribeRuleGroupMetadataResponse::ruleGroupArn))
            .setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()).build();

    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupName").getter(getter(DescribeRuleGroupMetadataResponse::ruleGroupName))
            .setter(setter(Builder::ruleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeRuleGroupMetadataResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeRuleGroupMetadataResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Capacity").getter(getter(DescribeRuleGroupMetadataResponse::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<StatefulRuleOptions> STATEFUL_RULE_OPTIONS_FIELD = SdkField
            .<StatefulRuleOptions> builder(MarshallingType.SDK_POJO).memberName("StatefulRuleOptions")
            .getter(getter(DescribeRuleGroupMetadataResponse::statefulRuleOptions)).setter(setter(Builder::statefulRuleOptions))
            .constructor(StatefulRuleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleOptions").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeRuleGroupMetadataResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD,
            RULE_GROUP_NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CAPACITY_FIELD, STATEFUL_RULE_OPTIONS_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private final String ruleGroupArn;

    private final String ruleGroupName;

    private final String description;

    private final String type;

    private final Integer capacity;

    private final StatefulRuleOptions statefulRuleOptions;

    private final Instant lastModifiedTime;

    private DescribeRuleGroupMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupName = builder.ruleGroupName;
        this.description = builder.description;
        this.type = builder.type;
        this.capacity = builder.capacity;
        this.statefulRuleOptions = builder.statefulRuleOptions;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the rule group. You can't change the name of a rule group after you create
     *         it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * <p>
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the rule group. You can't change the name of a rule group after you create
     *         it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String ruleGroupName() {
        return ruleGroupName;
    }

    /**
     * <p>
     * Returns the metadata objects for the specified rule group.
     * </p>
     * 
     * @return Returns the metadata objects for the specified rule group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <note>
     * <p>
     * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules. </p> <note>
     *         <p>
     *         This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     *         </p>
     * @see RuleGroupType
     */
    public final RuleGroupType type() {
        return RuleGroupType.fromValue(type);
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <note>
     * <p>
     * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules. </p> <note>
     *         <p>
     *         This setting is required for requests that do not include the <code>RuleGroupARN</code>.
     *         </p>
     * @see RuleGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you
     * update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy,
     * Network Firewall reserves this capacity for the rule group.
     * </p>
     * <p>
     * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
     * <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
     * </p>
     * 
     * @return The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
     *         When you update a rule group, you are limited to this capacity. When you reference a rule group from a
     *         firewall policy, Network Firewall reserves this capacity for the rule group. </p>
     *         <p>
     *         You can retrieve the capacity that would be required for a rule group before you create the rule group by
     *         calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * Returns the value of the StatefulRuleOptions property for this object.
     * 
     * @return The value of the StatefulRuleOptions property for this object.
     */
    public final StatefulRuleOptions statefulRuleOptions() {
        return statefulRuleOptions;
    }

    /**
     * <p>
     * The last time that the rule group was changed.
     * </p>
     * 
     * @return The last time that the rule group was changed.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(statefulRuleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuleGroupMetadataResponse)) {
            return false;
        }
        DescribeRuleGroupMetadataResponse other = (DescribeRuleGroupMetadataResponse) obj;
        return Objects.equals(ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(ruleGroupName(), other.ruleGroupName())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(capacity(), other.capacity())
                && Objects.equals(statefulRuleOptions(), other.statefulRuleOptions())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRuleGroupMetadataResponse").add("RuleGroupArn", ruleGroupArn())
                .add("RuleGroupName", ruleGroupName()).add("Description", description()).add("Type", typeAsString())
                .add("Capacity", capacity()).add("StatefulRuleOptions", statefulRuleOptions())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "RuleGroupName":
            return Optional.ofNullable(clazz.cast(ruleGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "StatefulRuleOptions":
            return Optional.ofNullable(clazz.cast(statefulRuleOptions()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuleGroupMetadataResponse, T> g) {
        return obj -> g.apply((DescribeRuleGroupMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRuleGroupMetadataResponse> {
        /**
         * <p>
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param ruleGroupArn
         *        The descriptive name of the rule group. You can't change the name of a rule group after you create
         *        it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param ruleGroupName
         *        The descriptive name of the rule group. You can't change the name of a rule group after you create
         *        it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupName(String ruleGroupName);

        /**
         * <p>
         * Returns the metadata objects for the specified rule group.
         * </p>
         * 
         * @param description
         *        Returns the metadata objects for the specified rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * <note>
         * <p>
         * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules. </p> <note>
         *        <p>
         *        This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         *        </p>
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * <note>
         * <p>
         * This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules. </p> <note>
         *        <p>
         *        This setting is required for requests that do not include the <code>RuleGroupARN</code>.
         *        </p>
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(RuleGroupType type);

        /**
         * <p>
         * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When
         * you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall
         * policy, Network Firewall reserves this capacity for the rule group.
         * </p>
         * <p>
         * You can retrieve the capacity that would be required for a rule group before you create the rule group by
         * calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
         * </p>
         * 
         * @param capacity
         *        The maximum operating resources that this rule group can use. Rule group capacity is fixed at
         *        creation. When you update a rule group, you are limited to this capacity. When you reference a rule
         *        group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
         *        <p>
         *        You can retrieve the capacity that would be required for a rule group before you create the rule group
         *        by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * Sets the value of the StatefulRuleOptions property for this object.
         *
         * @param statefulRuleOptions
         *        The new value for the StatefulRuleOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleOptions(StatefulRuleOptions statefulRuleOptions);

        /**
         * Sets the value of the StatefulRuleOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StatefulRuleOptions.Builder} avoiding the
         * need to create one manually via {@link StatefulRuleOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatefulRuleOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #statefulRuleOptions(StatefulRuleOptions)}.
         * 
         * @param statefulRuleOptions
         *        a consumer that will call methods on {@link StatefulRuleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRuleOptions(StatefulRuleOptions)
         */
        default Builder statefulRuleOptions(Consumer<StatefulRuleOptions.Builder> statefulRuleOptions) {
            return statefulRuleOptions(StatefulRuleOptions.builder().applyMutation(statefulRuleOptions).build());
        }

        /**
         * <p>
         * The last time that the rule group was changed.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that the rule group was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String ruleGroupArn;

        private String ruleGroupName;

        private String description;

        private String type;

        private Integer capacity;

        private StatefulRuleOptions statefulRuleOptions;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuleGroupMetadataResponse model) {
            super(model);
            ruleGroupArn(model.ruleGroupArn);
            ruleGroupName(model.ruleGroupName);
            description(model.description);
            type(model.type);
            capacity(model.capacity);
            statefulRuleOptions(model.statefulRuleOptions);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupName() {
            return ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final StatefulRuleOptions.Builder getStatefulRuleOptions() {
            return statefulRuleOptions != null ? statefulRuleOptions.toBuilder() : null;
        }

        public final void setStatefulRuleOptions(StatefulRuleOptions.BuilderImpl statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions != null ? statefulRuleOptions.build() : null;
        }

        @Override
        public final Builder statefulRuleOptions(StatefulRuleOptions statefulRuleOptions) {
            this.statefulRuleOptions = statefulRuleOptions;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeRuleGroupMetadataResponse build() {
            return new DescribeRuleGroupMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
