/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.networkfirewall.DefaultNetworkFirewallBaseClientBuilder;
import software.amazon.awssdk.services.networkfirewall.DefaultNetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClientBuilder;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallServiceClientConfiguration;
import software.amazon.awssdk.services.networkfirewall.endpoints.NetworkFirewallEndpointProvider;

@SdkInternalApi
final class DefaultNetworkFirewallClientBuilder
extends DefaultNetworkFirewallBaseClientBuilder<NetworkFirewallClientBuilder, NetworkFirewallClient>
implements NetworkFirewallClientBuilder {
    DefaultNetworkFirewallClientBuilder() {
    }

    @Override
    public DefaultNetworkFirewallClientBuilder endpointProvider(NetworkFirewallEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NetworkFirewallClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultNetworkFirewallClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        NetworkFirewallServiceClientConfiguration serviceClientConfiguration = NetworkFirewallServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultNetworkFirewallClient(serviceClientConfiguration, clientConfiguration);
    }
}

