/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata;

public class ListTLSInspectionConfigurationsIterable
implements SdkIterable<ListTlsInspectionConfigurationsResponse> {
    private final NetworkFirewallClient client;
    private final ListTlsInspectionConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTLSInspectionConfigurationsIterable(NetworkFirewallClient client, ListTlsInspectionConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTlsInspectionConfigurationsResponseFetcher();
    }

    public Iterator<ListTlsInspectionConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TLSInspectionConfigurationMetadata> tlsInspectionConfigurations() {
        Function<ListTlsInspectionConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tlsInspectionConfigurations() != null) {
                return response.tlsInspectionConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTlsInspectionConfigurationsResponseFetcher
    implements SyncPageFetcher<ListTlsInspectionConfigurationsResponse> {
        private ListTlsInspectionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTlsInspectionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTlsInspectionConfigurationsResponse nextPage(ListTlsInspectionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTLSInspectionConfigurationsIterable.this.client.listTLSInspectionConfigurations(ListTLSInspectionConfigurationsIterable.this.firstRequest);
            }
            return ListTLSInspectionConfigurationsIterable.this.client.listTLSInspectionConfigurations((ListTlsInspectionConfigurationsRequest)((Object)ListTLSInspectionConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

