/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a set of IP set references.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceSets implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceSets.Builder, ReferenceSets> {
    private static final SdkField<Map<String, IPSetReference>> IP_SET_REFERENCES_FIELD = SdkField
            .<Map<String, IPSetReference>> builder(MarshallingType.MAP)
            .memberName("IPSetReferences")
            .getter(getter(ReferenceSets::ipSetReferences))
            .setter(setter(Builder::ipSetReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetReferences").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IPSetReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSetReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_REFERENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, IPSetReference> ipSetReferences;

    private ReferenceSets(BuilderImpl builder) {
        this.ipSetReferences = builder.ipSetReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the IPSetReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpSetReferences() {
        return ipSetReferences != null && !(ipSetReferences instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of IP set references.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpSetReferences} method.
     * </p>
     * 
     * @return The list of IP set references.
     */
    public final Map<String, IPSetReference> ipSetReferences() {
        return ipSetReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSetReferences() ? ipSetReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSets)) {
            return false;
        }
        ReferenceSets other = (ReferenceSets) obj;
        return hasIpSetReferences() == other.hasIpSetReferences() && Objects.equals(ipSetReferences(), other.ipSetReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceSets").add("IPSetReferences", hasIpSetReferences() ? ipSetReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPSetReferences":
            return Optional.ofNullable(clazz.cast(ipSetReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceSets, T> g) {
        return obj -> g.apply((ReferenceSets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceSets> {
        /**
         * <p>
         * The list of IP set references.
         * </p>
         * 
         * @param ipSetReferences
         *        The list of IP set references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetReferences(Map<String, IPSetReference> ipSetReferences);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, IPSetReference> ipSetReferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceSets model) {
            ipSetReferences(model.ipSetReferences);
        }

        public final Map<String, IPSetReference.Builder> getIpSetReferences() {
            Map<String, IPSetReference.Builder> result = IPSetReferenceMapCopier.copyToBuilder(this.ipSetReferences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setIpSetReferences(Map<String, IPSetReference.BuilderImpl> ipSetReferences) {
            this.ipSetReferences = IPSetReferenceMapCopier.copyFromBuilder(ipSetReferences);
        }

        @Override
        public final Builder ipSetReferences(Map<String, IPSetReference> ipSetReferences) {
            this.ipSetReferences = IPSetReferenceMapCopier.copy(ipSetReferences);
            return this;
        }

        @Override
        public ReferenceSets build() {
            return new ReferenceSets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
