/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FlagsCopier;
import software.amazon.awssdk.services.networkfirewall.model.TCPFlag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TCPFlagField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TCPFlagField> {
    private static final SdkField<List<String>> FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Flags").getter(TCPFlagField.getter(TCPFlagField::flagsAsStrings)).setter(TCPFlagField.setter(Builder::flagsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Masks").getter(TCPFlagField.getter(TCPFlagField::masksAsStrings)).setter(TCPFlagField.setter(Builder::masksWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Masks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAGS_FIELD, MASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Flags", FLAGS_FIELD);
            this.put("Masks", MASKS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> flags;
    private final List<String> masks;

    private TCPFlagField(BuilderImpl builder) {
        this.flags = builder.flags;
        this.masks = builder.masks;
    }

    public final List<TCPFlag> flags() {
        return FlagsCopier.copyStringToEnum(this.flags);
    }

    public final boolean hasFlags() {
        return this.flags != null && !(this.flags instanceof SdkAutoConstructList);
    }

    public final List<String> flagsAsStrings() {
        return this.flags;
    }

    public final List<TCPFlag> masks() {
        return FlagsCopier.copyStringToEnum(this.masks);
    }

    public final boolean hasMasks() {
        return this.masks != null && !(this.masks instanceof SdkAutoConstructList);
    }

    public final List<String> masksAsStrings() {
        return this.masks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlags() ? this.flagsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMasks() ? this.masksAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TCPFlagField)) {
            return false;
        }
        TCPFlagField other = (TCPFlagField)obj;
        return this.hasFlags() == other.hasFlags() && Objects.equals(this.flagsAsStrings(), other.flagsAsStrings()) && this.hasMasks() == other.hasMasks() && Objects.equals(this.masksAsStrings(), other.masksAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TCPFlagField").add("Flags", this.hasFlags() ? this.flagsAsStrings() : null).add("Masks", this.hasMasks() ? this.masksAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flags": {
                return Optional.ofNullable(clazz.cast(this.flagsAsStrings()));
            }
            case "Masks": {
                return Optional.ofNullable(clazz.cast(this.masksAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TCPFlagField, T> g) {
        return obj -> g.apply((TCPFlagField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> flags = DefaultSdkAutoConstructList.getInstance();
        private List<String> masks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TCPFlagField model) {
            this.flagsWithStrings(model.flags);
            this.masksWithStrings(model.masks);
        }

        public final Collection<String> getFlags() {
            if (this.flags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.flags;
        }

        public final void setFlags(Collection<String> flags) {
            this.flags = FlagsCopier.copy(flags);
        }

        @Override
        public final Builder flagsWithStrings(Collection<String> flags) {
            this.flags = FlagsCopier.copy(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flagsWithStrings(String ... flags) {
            this.flagsWithStrings(Arrays.asList(flags));
            return this;
        }

        @Override
        public final Builder flags(Collection<TCPFlag> flags) {
            this.flags = FlagsCopier.copyEnumToString(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flags(TCPFlag ... flags) {
            this.flags(Arrays.asList(flags));
            return this;
        }

        public final Collection<String> getMasks() {
            if (this.masks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.masks;
        }

        public final void setMasks(Collection<String> masks) {
            this.masks = FlagsCopier.copy(masks);
        }

        @Override
        public final Builder masksWithStrings(Collection<String> masks) {
            this.masks = FlagsCopier.copy(masks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder masksWithStrings(String ... masks) {
            this.masksWithStrings(Arrays.asList(masks));
            return this;
        }

        @Override
        public final Builder masks(Collection<TCPFlag> masks) {
            this.masks = FlagsCopier.copyEnumToString(masks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder masks(TCPFlag ... masks) {
            this.masks(Arrays.asList(masks));
            return this;
        }

        public TCPFlagField build() {
            return new TCPFlagField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TCPFlagField> {
        public Builder flagsWithStrings(Collection<String> var1);

        public Builder flagsWithStrings(String ... var1);

        public Builder flags(Collection<TCPFlag> var1);

        public Builder flags(TCPFlag ... var1);

        public Builder masksWithStrings(Collection<String> var1);

        public Builder masksWithStrings(String ... var1);

        public Builder masks(Collection<TCPFlag> var1);

        public Builder masks(TCPFlag ... var1);
    }
}

