/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTlsInspectionConfigurationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, UpdateTlsInspectionConfigurationRequest> {
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationArn").getter(UpdateTlsInspectionConfigurationRequest.getter(UpdateTlsInspectionConfigurationRequest::tlsInspectionConfigurationArn)).setter(UpdateTlsInspectionConfigurationRequest.setter(Builder::tlsInspectionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn").build()}).build();
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationName").getter(UpdateTlsInspectionConfigurationRequest.getter(UpdateTlsInspectionConfigurationRequest::tlsInspectionConfigurationName)).setter(UpdateTlsInspectionConfigurationRequest.setter(Builder::tlsInspectionConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationName").build()}).build();
    private static final SdkField<TLSInspectionConfiguration> TLS_INSPECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TLSInspectionConfiguration").getter(UpdateTlsInspectionConfigurationRequest.getter(UpdateTlsInspectionConfigurationRequest::tlsInspectionConfiguration)).setter(UpdateTlsInspectionConfigurationRequest.setter(Builder::tlsInspectionConfiguration)).constructor(TLSInspectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateTlsInspectionConfigurationRequest.getter(UpdateTlsInspectionConfigurationRequest::description)).setter(UpdateTlsInspectionConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(UpdateTlsInspectionConfigurationRequest.getter(UpdateTlsInspectionConfigurationRequest::encryptionConfiguration)).setter(UpdateTlsInspectionConfigurationRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateTlsInspectionConfigurationRequest.getter(UpdateTlsInspectionConfigurationRequest::updateToken)).setter(UpdateTlsInspectionConfigurationRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_INSPECTION_CONFIGURATION_ARN_FIELD, TLS_INSPECTION_CONFIGURATION_NAME_FIELD, TLS_INSPECTION_CONFIGURATION_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TLSInspectionConfigurationArn", TLS_INSPECTION_CONFIGURATION_ARN_FIELD);
            this.put("TLSInspectionConfigurationName", TLS_INSPECTION_CONFIGURATION_NAME_FIELD);
            this.put("TLSInspectionConfiguration", TLS_INSPECTION_CONFIGURATION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
            this.put("UpdateToken", UPDATE_TOKEN_FIELD);
        }
    });
    private final String tlsInspectionConfigurationArn;
    private final String tlsInspectionConfigurationName;
    private final TLSInspectionConfiguration tlsInspectionConfiguration;
    private final String description;
    private final EncryptionConfiguration encryptionConfiguration;
    private final String updateToken;

    private UpdateTlsInspectionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.tlsInspectionConfigurationName = builder.tlsInspectionConfigurationName;
        this.tlsInspectionConfiguration = builder.tlsInspectionConfiguration;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.updateToken = builder.updateToken;
    }

    public final String tlsInspectionConfigurationArn() {
        return this.tlsInspectionConfigurationArn;
    }

    public final String tlsInspectionConfigurationName() {
        return this.tlsInspectionConfigurationName;
    }

    public final TLSInspectionConfiguration tlsInspectionConfiguration() {
        return this.tlsInspectionConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTlsInspectionConfigurationRequest)) {
            return false;
        }
        UpdateTlsInspectionConfigurationRequest other = (UpdateTlsInspectionConfigurationRequest)((Object)obj);
        return Objects.equals(this.tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn()) && Objects.equals(this.tlsInspectionConfigurationName(), other.tlsInspectionConfigurationName()) && Objects.equals(this.tlsInspectionConfiguration(), other.tlsInspectionConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTlsInspectionConfigurationRequest").add("TLSInspectionConfigurationArn", (Object)this.tlsInspectionConfigurationArn()).add("TLSInspectionConfigurationName", (Object)this.tlsInspectionConfigurationName()).add("TLSInspectionConfiguration", (Object)this.tlsInspectionConfiguration()).add("Description", (Object)this.description()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TLSInspectionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationArn()));
            }
            case "TLSInspectionConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationName()));
            }
            case "TLSInspectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTlsInspectionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateTlsInspectionConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String tlsInspectionConfigurationArn;
        private String tlsInspectionConfigurationName;
        private TLSInspectionConfiguration tlsInspectionConfiguration;
        private String description;
        private EncryptionConfiguration encryptionConfiguration;
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTlsInspectionConfigurationRequest model) {
            super(model);
            this.tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            this.tlsInspectionConfigurationName(model.tlsInspectionConfigurationName);
            this.tlsInspectionConfiguration(model.tlsInspectionConfiguration);
            this.description(model.description);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.updateToken(model.updateToken);
        }

        public final String getTlsInspectionConfigurationArn() {
            return this.tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final String getTlsInspectionConfigurationName() {
            return this.tlsInspectionConfigurationName;
        }

        public final void setTlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
        }

        @Override
        public final Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        public final TLSInspectionConfiguration.Builder getTlsInspectionConfiguration() {
            return this.tlsInspectionConfiguration != null ? this.tlsInspectionConfiguration.toBuilder() : null;
        }

        public final void setTlsInspectionConfiguration(TLSInspectionConfiguration.BuilderImpl tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration != null ? tlsInspectionConfiguration.build() : null;
        }

        @Override
        public final Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTlsInspectionConfigurationRequest build() {
            return new UpdateTlsInspectionConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTlsInspectionConfigurationRequest> {
        public Builder tlsInspectionConfigurationArn(String var1);

        public Builder tlsInspectionConfigurationName(String var1);

        public Builder tlsInspectionConfiguration(TLSInspectionConfiguration var1);

        default public Builder tlsInspectionConfiguration(Consumer<TLSInspectionConfiguration.Builder> tlsInspectionConfiguration) {
            return this.tlsInspectionConfiguration((TLSInspectionConfiguration)((TLSInspectionConfiguration.Builder)TLSInspectionConfiguration.builder().applyMutation(tlsInspectionConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

