/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnabledAnalysisType {
    TLS_SNI("TLS_SNI"),
    HTTP_HOST("HTTP_HOST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnabledAnalysisType> VALUE_MAP;
    private final String value;

    private EnabledAnalysisType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnabledAnalysisType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnabledAnalysisType> knownValues() {
        EnumSet<EnabledAnalysisType> knownValues = EnumSet.allOf(EnabledAnalysisType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnabledAnalysisType.class, EnabledAnalysisType::toString);
    }
}

