/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisReport;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse;

public class ListAnalysisReportsPublisher
implements SdkPublisher<ListAnalysisReportsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListAnalysisReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnalysisReportsPublisher(NetworkFirewallAsyncClient client, ListAnalysisReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnalysisReportsPublisher(NetworkFirewallAsyncClient client, ListAnalysisReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnalysisReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnalysisReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalysisReport> analysisReports() {
        Function<ListAnalysisReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisReports() != null) {
                return response.analysisReports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnalysisReportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnalysisReportsResponseFetcher
    implements AsyncPageFetcher<ListAnalysisReportsResponse> {
        private ListAnalysisReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalysisReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnalysisReportsResponse> nextPage(ListAnalysisReportsResponse previousPage) {
            if (previousPage == null) {
                return ListAnalysisReportsPublisher.this.client.listAnalysisReports(ListAnalysisReportsPublisher.this.firstRequest);
            }
            return ListAnalysisReportsPublisher.this.client.listAnalysisReports((ListAnalysisReportsRequest)((Object)ListAnalysisReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

