/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.EnabledAnalysisType;
import software.amazon.awssdk.services.networkfirewall.model.EnabledAnalysisTypesCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFirewallAnalysisSettingsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, UpdateFirewallAnalysisSettingsResponse> {
    private static final SdkField<List<String>> ENABLED_ANALYSIS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledAnalysisTypes").getter(UpdateFirewallAnalysisSettingsResponse.getter(UpdateFirewallAnalysisSettingsResponse::enabledAnalysisTypesAsStrings)).setter(UpdateFirewallAnalysisSettingsResponse.setter(Builder::enabledAnalysisTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledAnalysisTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(UpdateFirewallAnalysisSettingsResponse.getter(UpdateFirewallAnalysisSettingsResponse::firewallArn)).setter(UpdateFirewallAnalysisSettingsResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(UpdateFirewallAnalysisSettingsResponse.getter(UpdateFirewallAnalysisSettingsResponse::firewallName)).setter(UpdateFirewallAnalysisSettingsResponse.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateFirewallAnalysisSettingsResponse.getter(UpdateFirewallAnalysisSettingsResponse::updateToken)).setter(UpdateFirewallAnalysisSettingsResponse.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_ANALYSIS_TYPES_FIELD, FIREWALL_ARN_FIELD, FIREWALL_NAME_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFirewallAnalysisSettingsResponse.memberNameToFieldInitializer();
    private final List<String> enabledAnalysisTypes;
    private final String firewallArn;
    private final String firewallName;
    private final String updateToken;

    private UpdateFirewallAnalysisSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.enabledAnalysisTypes = builder.enabledAnalysisTypes;
        this.firewallArn = builder.firewallArn;
        this.firewallName = builder.firewallName;
        this.updateToken = builder.updateToken;
    }

    public final List<EnabledAnalysisType> enabledAnalysisTypes() {
        return EnabledAnalysisTypesCopier.copyStringToEnum(this.enabledAnalysisTypes);
    }

    public final boolean hasEnabledAnalysisTypes() {
        return this.enabledAnalysisTypes != null && !(this.enabledAnalysisTypes instanceof SdkAutoConstructList);
    }

    public final List<String> enabledAnalysisTypesAsStrings() {
        return this.enabledAnalysisTypes;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String firewallName() {
        return this.firewallName;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledAnalysisTypes() ? this.enabledAnalysisTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallAnalysisSettingsResponse)) {
            return false;
        }
        UpdateFirewallAnalysisSettingsResponse other = (UpdateFirewallAnalysisSettingsResponse)((Object)obj);
        return this.hasEnabledAnalysisTypes() == other.hasEnabledAnalysisTypes() && Objects.equals(this.enabledAnalysisTypesAsStrings(), other.enabledAnalysisTypesAsStrings()) && Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.firewallName(), other.firewallName()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFirewallAnalysisSettingsResponse").add("EnabledAnalysisTypes", this.hasEnabledAnalysisTypes() ? this.enabledAnalysisTypesAsStrings() : null).add("FirewallArn", (Object)this.firewallArn()).add("FirewallName", (Object)this.firewallName()).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledAnalysisTypes": {
                return Optional.ofNullable(clazz.cast(this.enabledAnalysisTypesAsStrings()));
            }
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnabledAnalysisTypes", ENABLED_ANALYSIS_TYPES_FIELD);
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallAnalysisSettingsResponse, T> g) {
        return obj -> g.apply((UpdateFirewallAnalysisSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<String> enabledAnalysisTypes = DefaultSdkAutoConstructList.getInstance();
        private String firewallArn;
        private String firewallName;
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallAnalysisSettingsResponse model) {
            super(model);
            this.enabledAnalysisTypesWithStrings(model.enabledAnalysisTypes);
            this.firewallArn(model.firewallArn);
            this.firewallName(model.firewallName);
            this.updateToken(model.updateToken);
        }

        public final Collection<String> getEnabledAnalysisTypes() {
            if (this.enabledAnalysisTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledAnalysisTypes;
        }

        public final void setEnabledAnalysisTypes(Collection<String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copy(enabledAnalysisTypes);
        }

        @Override
        public final Builder enabledAnalysisTypesWithStrings(Collection<String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copy(enabledAnalysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledAnalysisTypesWithStrings(String ... enabledAnalysisTypes) {
            this.enabledAnalysisTypesWithStrings(Arrays.asList(enabledAnalysisTypes));
            return this;
        }

        @Override
        public final Builder enabledAnalysisTypes(Collection<EnabledAnalysisType> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copyEnumToString(enabledAnalysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledAnalysisTypes(EnabledAnalysisType ... enabledAnalysisTypes) {
            this.enabledAnalysisTypes(Arrays.asList(enabledAnalysisTypes));
            return this;
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public UpdateFirewallAnalysisSettingsResponse build() {
            return new UpdateFirewallAnalysisSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFirewallAnalysisSettingsResponse> {
        public Builder enabledAnalysisTypesWithStrings(Collection<String> var1);

        public Builder enabledAnalysisTypesWithStrings(String ... var1);

        public Builder enabledAnalysisTypes(Collection<EnabledAnalysisType> var1);

        public Builder enabledAnalysisTypes(EnabledAnalysisType ... var1);

        public Builder firewallArn(String var1);

        public Builder firewallName(String var1);

        public Builder updateToken(String var1);
    }
}

