/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMetadata;
import software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.SupportedAvailabilityZonesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFirewallMetadataResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, DescribeFirewallMetadataResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(DescribeFirewallMetadataResponse.getter(DescribeFirewallMetadataResponse::firewallArn)).setter(DescribeFirewallMetadataResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyArn").getter(DescribeFirewallMetadataResponse.getter(DescribeFirewallMetadataResponse::firewallPolicyArn)).setter(DescribeFirewallMetadataResponse.setter(Builder::firewallPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeFirewallMetadataResponse.getter(DescribeFirewallMetadataResponse::description)).setter(DescribeFirewallMetadataResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeFirewallMetadataResponse.getter(DescribeFirewallMetadataResponse::statusAsString)).setter(DescribeFirewallMetadataResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, AvailabilityZoneMetadata>> SUPPORTED_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SupportedAvailabilityZones").getter(DescribeFirewallMetadataResponse.getter(DescribeFirewallMetadataResponse::supportedAvailabilityZones)).setter(DescribeFirewallMetadataResponse.setter(Builder::supportedAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAvailabilityZones").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZoneMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, FIREWALL_POLICY_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SUPPORTED_AVAILABILITY_ZONES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFirewallMetadataResponse.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String firewallPolicyArn;
    private final String description;
    private final String status;
    private final Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones;

    private DescribeFirewallMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.description = builder.description;
        this.status = builder.status;
        this.supportedAvailabilityZones = builder.supportedAvailabilityZones;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String firewallPolicyArn() {
        return this.firewallPolicyArn;
    }

    public final String description() {
        return this.description;
    }

    public final FirewallStatusValue status() {
        return FirewallStatusValue.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSupportedAvailabilityZones() {
        return this.supportedAvailabilityZones != null && !(this.supportedAvailabilityZones instanceof SdkAutoConstructMap);
    }

    public final Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones() {
        return this.supportedAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedAvailabilityZones() ? this.supportedAvailabilityZones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFirewallMetadataResponse)) {
            return false;
        }
        DescribeFirewallMetadataResponse other = (DescribeFirewallMetadataResponse)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.firewallPolicyArn(), other.firewallPolicyArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSupportedAvailabilityZones() == other.hasSupportedAvailabilityZones() && Objects.equals(this.supportedAvailabilityZones(), other.supportedAvailabilityZones());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFirewallMetadataResponse").add("FirewallArn", (Object)this.firewallArn()).add("FirewallPolicyArn", (Object)this.firewallPolicyArn()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("SupportedAvailabilityZones", this.hasSupportedAvailabilityZones() ? this.supportedAvailabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FirewallPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SupportedAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.supportedAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FirewallPolicyArn", FIREWALL_POLICY_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SupportedAvailabilityZones", SUPPORTED_AVAILABILITY_ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFirewallMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFirewallMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String firewallPolicyArn;
        private String description;
        private String status;
        private Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFirewallMetadataResponse model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.firewallPolicyArn(model.firewallPolicyArn);
            this.description(model.description);
            this.status(model.status);
            this.supportedAvailabilityZones(model.supportedAvailabilityZones);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, AvailabilityZoneMetadata.Builder> getSupportedAvailabilityZones() {
            Map<String, AvailabilityZoneMetadata.Builder> result = SupportedAvailabilityZonesCopier.copyToBuilder(this.supportedAvailabilityZones);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSupportedAvailabilityZones(Map<String, AvailabilityZoneMetadata.BuilderImpl> supportedAvailabilityZones) {
            this.supportedAvailabilityZones = SupportedAvailabilityZonesCopier.copyFromBuilder(supportedAvailabilityZones);
        }

        @Override
        public final Builder supportedAvailabilityZones(Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones) {
            this.supportedAvailabilityZones = SupportedAvailabilityZonesCopier.copy(supportedAvailabilityZones);
            return this;
        }

        @Override
        public DescribeFirewallMetadataResponse build() {
            return new DescribeFirewallMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFirewallMetadataResponse> {
        public Builder firewallArn(String var1);

        public Builder firewallPolicyArn(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(FirewallStatusValue var1);

        public Builder supportedAvailabilityZones(Map<String, AvailabilityZoneMetadata> var1);
    }
}

