/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisResult;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisResultListCopier;
import software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration;
import software.amazon.awssdk.services.networkfirewall.model.ResourceStatus;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupType;
import software.amazon.awssdk.services.networkfirewall.model.SourceMetadata;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupResponse> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupArn)).setter(RuleGroupResponse.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()}).build();
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupName").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupName)).setter(RuleGroupResponse.setter(Builder::ruleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()}).build();
    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupId").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupId)).setter(RuleGroupResponse.setter(Builder::ruleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RuleGroupResponse.getter(RuleGroupResponse::description)).setter(RuleGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RuleGroupResponse.getter(RuleGroupResponse::typeAsString)).setter(RuleGroupResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Capacity").getter(RuleGroupResponse.getter(RuleGroupResponse::capacity)).setter(RuleGroupResponse.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<String> RULE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupStatus").getter(RuleGroupResponse.getter(RuleGroupResponse::ruleGroupStatusAsString)).setter(RuleGroupResponse.setter(Builder::ruleGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RuleGroupResponse.getter(RuleGroupResponse::tags)).setter(RuleGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConsumedCapacity").getter(RuleGroupResponse.getter(RuleGroupResponse::consumedCapacity)).setter(RuleGroupResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssociations").getter(RuleGroupResponse.getter(RuleGroupResponse::numberOfAssociations)).setter(RuleGroupResponse.setter(Builder::numberOfAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociations").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(RuleGroupResponse.getter(RuleGroupResponse::encryptionConfiguration)).setter(RuleGroupResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<SourceMetadata> SOURCE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceMetadata").getter(RuleGroupResponse.getter(RuleGroupResponse::sourceMetadata)).setter(RuleGroupResponse.setter(Builder::sourceMetadata)).constructor(SourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceMetadata").build()}).build();
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopic").getter(RuleGroupResponse.getter(RuleGroupResponse::snsTopic)).setter(RuleGroupResponse.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopic").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(RuleGroupResponse.getter(RuleGroupResponse::lastModifiedTime)).setter(RuleGroupResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<List<AnalysisResult>> ANALYSIS_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisResults").getter(RuleGroupResponse.getter(RuleGroupResponse::analysisResults)).setter(RuleGroupResponse.setter(Builder::analysisResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD, RULE_GROUP_NAME_FIELD, RULE_GROUP_ID_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CAPACITY_FIELD, RULE_GROUP_STATUS_FIELD, TAGS_FIELD, CONSUMED_CAPACITY_FIELD, NUMBER_OF_ASSOCIATIONS_FIELD, ENCRYPTION_CONFIGURATION_FIELD, SOURCE_METADATA_FIELD, SNS_TOPIC_FIELD, LAST_MODIFIED_TIME_FIELD, ANALYSIS_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleGroupResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleGroupArn;
    private final String ruleGroupName;
    private final String ruleGroupId;
    private final String description;
    private final String type;
    private final Integer capacity;
    private final String ruleGroupStatus;
    private final List<Tag> tags;
    private final Integer consumedCapacity;
    private final Integer numberOfAssociations;
    private final EncryptionConfiguration encryptionConfiguration;
    private final SourceMetadata sourceMetadata;
    private final String snsTopic;
    private final Instant lastModifiedTime;
    private final List<AnalysisResult> analysisResults;

    private RuleGroupResponse(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroupId = builder.ruleGroupId;
        this.description = builder.description;
        this.type = builder.type;
        this.capacity = builder.capacity;
        this.ruleGroupStatus = builder.ruleGroupStatus;
        this.tags = builder.tags;
        this.consumedCapacity = builder.consumedCapacity;
        this.numberOfAssociations = builder.numberOfAssociations;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.sourceMetadata = builder.sourceMetadata;
        this.snsTopic = builder.snsTopic;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.analysisResults = builder.analysisResults;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final String ruleGroupName() {
        return this.ruleGroupName;
    }

    public final String ruleGroupId() {
        return this.ruleGroupId;
    }

    public final String description() {
        return this.description;
    }

    public final RuleGroupType type() {
        return RuleGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public final ResourceStatus ruleGroupStatus() {
        return ResourceStatus.fromValue(this.ruleGroupStatus);
    }

    public final String ruleGroupStatusAsString() {
        return this.ruleGroupStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Integer consumedCapacity() {
        return this.consumedCapacity;
    }

    public final Integer numberOfAssociations() {
        return this.numberOfAssociations;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final SourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    public final String snsTopic() {
        return this.snsTopic;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasAnalysisResults() {
        return this.analysisResults != null && !(this.analysisResults instanceof SdkAutoConstructList);
    }

    public final List<AnalysisResult> analysisResults() {
        return this.analysisResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisResults() ? this.analysisResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupResponse)) {
            return false;
        }
        RuleGroupResponse other = (RuleGroupResponse)obj;
        return Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(this.ruleGroupName(), other.ruleGroupName()) && Objects.equals(this.ruleGroupId(), other.ruleGroupId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.ruleGroupStatusAsString(), other.ruleGroupStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && Objects.equals(this.numberOfAssociations(), other.numberOfAssociations()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.sourceMetadata(), other.sourceMetadata()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasAnalysisResults() == other.hasAnalysisResults() && Objects.equals(this.analysisResults(), other.analysisResults());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupResponse").add("RuleGroupArn", (Object)this.ruleGroupArn()).add("RuleGroupName", (Object)this.ruleGroupName()).add("RuleGroupId", (Object)this.ruleGroupId()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("Capacity", (Object)this.capacity()).add("RuleGroupStatus", (Object)this.ruleGroupStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ConsumedCapacity", (Object)this.consumedCapacity()).add("NumberOfAssociations", (Object)this.numberOfAssociations()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("SourceMetadata", (Object)this.sourceMetadata()).add("SnsTopic", (Object)this.snsTopic()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("AnalysisResults", this.hasAnalysisResults() ? this.analysisResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "RuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupName()));
            }
            case "RuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "RuleGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupStatusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "NumberOfAssociations": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociations()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "SourceMetadata": {
                return Optional.ofNullable(clazz.cast(this.sourceMetadata()));
            }
            case "SnsTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "AnalysisResults": {
                return Optional.ofNullable(clazz.cast(this.analysisResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleGroupArn", RULE_GROUP_ARN_FIELD);
        map.put("RuleGroupName", RULE_GROUP_NAME_FIELD);
        map.put("RuleGroupId", RULE_GROUP_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("RuleGroupStatus", RULE_GROUP_STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
        map.put("NumberOfAssociations", NUMBER_OF_ASSOCIATIONS_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("SourceMetadata", SOURCE_METADATA_FIELD);
        map.put("SnsTopic", SNS_TOPIC_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("AnalysisResults", ANALYSIS_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupResponse, T> g) {
        return obj -> g.apply((RuleGroupResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleGroupArn;
        private String ruleGroupName;
        private String ruleGroupId;
        private String description;
        private String type;
        private Integer capacity;
        private String ruleGroupStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer consumedCapacity;
        private Integer numberOfAssociations;
        private EncryptionConfiguration encryptionConfiguration;
        private SourceMetadata sourceMetadata;
        private String snsTopic;
        private Instant lastModifiedTime;
        private List<AnalysisResult> analysisResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupResponse model) {
            this.ruleGroupArn(model.ruleGroupArn);
            this.ruleGroupName(model.ruleGroupName);
            this.ruleGroupId(model.ruleGroupId);
            this.description(model.description);
            this.type(model.type);
            this.capacity(model.capacity);
            this.ruleGroupStatus(model.ruleGroupStatus);
            this.tags(model.tags);
            this.consumedCapacity(model.consumedCapacity);
            this.numberOfAssociations(model.numberOfAssociations);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.sourceMetadata(model.sourceMetadata);
            this.snsTopic(model.snsTopic);
            this.lastModifiedTime(model.lastModifiedTime);
            this.analysisResults(model.analysisResults);
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupName() {
            return this.ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getRuleGroupId() {
            return this.ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getRuleGroupStatus() {
            return this.ruleGroupStatus;
        }

        public final void setRuleGroupStatus(String ruleGroupStatus) {
            this.ruleGroupStatus = ruleGroupStatus;
        }

        @Override
        public final Builder ruleGroupStatus(String ruleGroupStatus) {
            this.ruleGroupStatus = ruleGroupStatus;
            return this;
        }

        @Override
        public final Builder ruleGroupStatus(ResourceStatus ruleGroupStatus) {
            this.ruleGroupStatus(ruleGroupStatus == null ? null : ruleGroupStatus.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public final void setConsumedCapacity(Integer consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(Integer consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final Integer getNumberOfAssociations() {
            return this.numberOfAssociations;
        }

        public final void setNumberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
        }

        @Override
        public final Builder numberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final SourceMetadata.Builder getSourceMetadata() {
            return this.sourceMetadata != null ? this.sourceMetadata.toBuilder() : null;
        }

        public final void setSourceMetadata(SourceMetadata.BuilderImpl sourceMetadata) {
            this.sourceMetadata = sourceMetadata != null ? sourceMetadata.build() : null;
        }

        @Override
        public final Builder sourceMetadata(SourceMetadata sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<AnalysisResult.Builder> getAnalysisResults() {
            List<AnalysisResult.Builder> result = AnalysisResultListCopier.copyToBuilder(this.analysisResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisResults(Collection<AnalysisResult.BuilderImpl> analysisResults) {
            this.analysisResults = AnalysisResultListCopier.copyFromBuilder(analysisResults);
        }

        @Override
        public final Builder analysisResults(Collection<AnalysisResult> analysisResults) {
            this.analysisResults = AnalysisResultListCopier.copy(analysisResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisResults(AnalysisResult ... analysisResults) {
            this.analysisResults(Arrays.asList(analysisResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisResults(Consumer<AnalysisResult.Builder> ... analysisResults) {
            this.analysisResults(Stream.of(analysisResults).map(c -> (AnalysisResult)((AnalysisResult.Builder)AnalysisResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RuleGroupResponse build() {
            return new RuleGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupResponse> {
        public Builder ruleGroupArn(String var1);

        public Builder ruleGroupName(String var1);

        public Builder ruleGroupId(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(RuleGroupType var1);

        public Builder capacity(Integer var1);

        public Builder ruleGroupStatus(String var1);

        public Builder ruleGroupStatus(ResourceStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder consumedCapacity(Integer var1);

        public Builder numberOfAssociations(Integer var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder sourceMetadata(SourceMetadata var1);

        default public Builder sourceMetadata(Consumer<SourceMetadata.Builder> sourceMetadata) {
            return this.sourceMetadata((SourceMetadata)((SourceMetadata.Builder)SourceMetadata.builder().applyMutation(sourceMetadata)).build());
        }

        public Builder snsTopic(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder analysisResults(Collection<AnalysisResult> var1);

        public Builder analysisResults(AnalysisResult ... var1);

        public Builder analysisResults(Consumer<AnalysisResult.Builder> ... var1);
    }
}

