/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationStatus;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFlowCaptureResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, StartFlowCaptureResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(StartFlowCaptureResponse.getter(StartFlowCaptureResponse::firewallArn)).setter(StartFlowCaptureResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationId").getter(StartFlowCaptureResponse.getter(StartFlowCaptureResponse::flowOperationId)).setter(StartFlowCaptureResponse.setter(Builder::flowOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationStatus").getter(StartFlowCaptureResponse.getter(StartFlowCaptureResponse::flowOperationStatusAsString)).setter(StartFlowCaptureResponse.setter(Builder::flowOperationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, FLOW_OPERATION_ID_FIELD, FLOW_OPERATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartFlowCaptureResponse.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String flowOperationId;
    private final String flowOperationStatus;

    private StartFlowCaptureResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationStatus = builder.flowOperationStatus;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String flowOperationId() {
        return this.flowOperationId;
    }

    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(this.flowOperationStatus);
    }

    public final String flowOperationStatusAsString() {
        return this.flowOperationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowCaptureResponse)) {
            return false;
        }
        StartFlowCaptureResponse other = (StartFlowCaptureResponse)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.flowOperationId(), other.flowOperationId()) && Objects.equals(this.flowOperationStatusAsString(), other.flowOperationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartFlowCaptureResponse").add("FirewallArn", (Object)this.firewallArn()).add("FlowOperationId", (Object)this.flowOperationId()).add("FlowOperationStatus", (Object)this.flowOperationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FlowOperationId": {
                return Optional.ofNullable(clazz.cast(this.flowOperationId()));
            }
            case "FlowOperationStatus": {
                return Optional.ofNullable(clazz.cast(this.flowOperationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFlowCaptureResponse, T> g) {
        return obj -> g.apply((StartFlowCaptureResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String flowOperationId;
        private String flowOperationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowCaptureResponse model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.flowOperationId(model.flowOperationId);
            this.flowOperationStatus(model.flowOperationStatus);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFlowOperationId() {
            return this.flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationStatus() {
            return this.flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        @Override
        public StartFlowCaptureResponse build() {
            return new StartFlowCaptureResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFlowCaptureResponse> {
        public Builder firewallArn(String var1);

        public Builder flowOperationId(String var1);

        public Builder flowOperationStatus(String var1);

        public Builder flowOperationStatus(FlowOperationStatus var1);
    }
}

