/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.RulesSourceList;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRule;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRulesCopier;
import software.amazon.awssdk.services.networkfirewall.model.StatelessRulesAndCustomActions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RulesSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RulesSource> {
    private static final SdkField<String> RULES_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RulesString").getter(RulesSource.getter(RulesSource::rulesString)).setter(RulesSource.setter(Builder::rulesString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesString").build()}).build();
    private static final SdkField<RulesSourceList> RULES_SOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RulesSourceList").getter(RulesSource.getter(RulesSource::rulesSourceList)).setter(RulesSource.setter(Builder::rulesSourceList)).constructor(RulesSourceList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSourceList").build()}).build();
    private static final SdkField<List<StatefulRule>> STATEFUL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatefulRules").getter(RulesSource.getter(RulesSource::statefulRules)).setter(RulesSource.setter(Builder::statefulRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatefulRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StatelessRulesAndCustomActions> STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatelessRulesAndCustomActions").getter(RulesSource.getter(RulesSource::statelessRulesAndCustomActions)).setter(RulesSource.setter(Builder::statelessRulesAndCustomActions)).constructor(StatelessRulesAndCustomActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRulesAndCustomActions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_STRING_FIELD, RULES_SOURCE_LIST_FIELD, STATEFUL_RULES_FIELD, STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RulesSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String rulesString;
    private final RulesSourceList rulesSourceList;
    private final List<StatefulRule> statefulRules;
    private final StatelessRulesAndCustomActions statelessRulesAndCustomActions;

    private RulesSource(BuilderImpl builder) {
        this.rulesString = builder.rulesString;
        this.rulesSourceList = builder.rulesSourceList;
        this.statefulRules = builder.statefulRules;
        this.statelessRulesAndCustomActions = builder.statelessRulesAndCustomActions;
    }

    public final String rulesString() {
        return this.rulesString;
    }

    public final RulesSourceList rulesSourceList() {
        return this.rulesSourceList;
    }

    public final boolean hasStatefulRules() {
        return this.statefulRules != null && !(this.statefulRules instanceof SdkAutoConstructList);
    }

    public final List<StatefulRule> statefulRules() {
        return this.statefulRules;
    }

    public final StatelessRulesAndCustomActions statelessRulesAndCustomActions() {
        return this.statelessRulesAndCustomActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesSourceList());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatefulRules() ? this.statefulRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statelessRulesAndCustomActions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesSource)) {
            return false;
        }
        RulesSource other = (RulesSource)obj;
        return Objects.equals(this.rulesString(), other.rulesString()) && Objects.equals(this.rulesSourceList(), other.rulesSourceList()) && this.hasStatefulRules() == other.hasStatefulRules() && Objects.equals(this.statefulRules(), other.statefulRules()) && Objects.equals(this.statelessRulesAndCustomActions(), other.statelessRulesAndCustomActions());
    }

    public final String toString() {
        return ToString.builder((String)"RulesSource").add("RulesString", (Object)this.rulesString()).add("RulesSourceList", (Object)this.rulesSourceList()).add("StatefulRules", this.hasStatefulRules() ? this.statefulRules() : null).add("StatelessRulesAndCustomActions", (Object)this.statelessRulesAndCustomActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RulesString": {
                return Optional.ofNullable(clazz.cast(this.rulesString()));
            }
            case "RulesSourceList": {
                return Optional.ofNullable(clazz.cast(this.rulesSourceList()));
            }
            case "StatefulRules": {
                return Optional.ofNullable(clazz.cast(this.statefulRules()));
            }
            case "StatelessRulesAndCustomActions": {
                return Optional.ofNullable(clazz.cast(this.statelessRulesAndCustomActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RulesString", RULES_STRING_FIELD);
        map.put("RulesSourceList", RULES_SOURCE_LIST_FIELD);
        map.put("StatefulRules", STATEFUL_RULES_FIELD);
        map.put("StatelessRulesAndCustomActions", STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RulesSource, T> g) {
        return obj -> g.apply((RulesSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rulesString;
        private RulesSourceList rulesSourceList;
        private List<StatefulRule> statefulRules = DefaultSdkAutoConstructList.getInstance();
        private StatelessRulesAndCustomActions statelessRulesAndCustomActions;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesSource model) {
            this.rulesString(model.rulesString);
            this.rulesSourceList(model.rulesSourceList);
            this.statefulRules(model.statefulRules);
            this.statelessRulesAndCustomActions(model.statelessRulesAndCustomActions);
        }

        public final String getRulesString() {
            return this.rulesString;
        }

        public final void setRulesString(String rulesString) {
            this.rulesString = rulesString;
        }

        @Override
        public final Builder rulesString(String rulesString) {
            this.rulesString = rulesString;
            return this;
        }

        public final RulesSourceList.Builder getRulesSourceList() {
            return this.rulesSourceList != null ? this.rulesSourceList.toBuilder() : null;
        }

        public final void setRulesSourceList(RulesSourceList.BuilderImpl rulesSourceList) {
            this.rulesSourceList = rulesSourceList != null ? rulesSourceList.build() : null;
        }

        @Override
        public final Builder rulesSourceList(RulesSourceList rulesSourceList) {
            this.rulesSourceList = rulesSourceList;
            return this;
        }

        public final List<StatefulRule.Builder> getStatefulRules() {
            List<StatefulRule.Builder> result = StatefulRulesCopier.copyToBuilder(this.statefulRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRules(Collection<StatefulRule.BuilderImpl> statefulRules) {
            this.statefulRules = StatefulRulesCopier.copyFromBuilder(statefulRules);
        }

        @Override
        public final Builder statefulRules(Collection<StatefulRule> statefulRules) {
            this.statefulRules = StatefulRulesCopier.copy(statefulRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRules(StatefulRule ... statefulRules) {
            this.statefulRules(Arrays.asList(statefulRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRules(Consumer<StatefulRule.Builder> ... statefulRules) {
            this.statefulRules(Stream.of(statefulRules).map(c -> (StatefulRule)((StatefulRule.Builder)StatefulRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StatelessRulesAndCustomActions.Builder getStatelessRulesAndCustomActions() {
            return this.statelessRulesAndCustomActions != null ? this.statelessRulesAndCustomActions.toBuilder() : null;
        }

        public final void setStatelessRulesAndCustomActions(StatelessRulesAndCustomActions.BuilderImpl statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions != null ? statelessRulesAndCustomActions.build() : null;
        }

        @Override
        public final Builder statelessRulesAndCustomActions(StatelessRulesAndCustomActions statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions;
            return this;
        }

        public RulesSource build() {
            return new RulesSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RulesSource> {
        public Builder rulesString(String var1);

        public Builder rulesSourceList(RulesSourceList var1);

        default public Builder rulesSourceList(Consumer<RulesSourceList.Builder> rulesSourceList) {
            return this.rulesSourceList((RulesSourceList)((RulesSourceList.Builder)RulesSourceList.builder().applyMutation(rulesSourceList)).build());
        }

        public Builder statefulRules(Collection<StatefulRule> var1);

        public Builder statefulRules(StatefulRule ... var1);

        public Builder statefulRules(Consumer<StatefulRule.Builder> ... var1);

        public Builder statelessRulesAndCustomActions(StatelessRulesAndCustomActions var1);

        default public Builder statelessRulesAndCustomActions(Consumer<StatelessRulesAndCustomActions.Builder> statelessRulesAndCustomActions) {
            return this.statelessRulesAndCustomActions((StatelessRulesAndCustomActions)((StatelessRulesAndCustomActions.Builder)StatelessRulesAndCustomActions.builder().applyMutation(statelessRulesAndCustomActions)).build());
        }
    }
}

