/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FirewallPoliciesCopier;
import software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallPoliciesResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListFirewallPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallPoliciesResponse.getter(ListFirewallPoliciesResponse::nextToken)).setter(ListFirewallPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FirewallPolicyMetadata>> FIREWALL_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirewallPolicies").getter(ListFirewallPoliciesResponse.getter(ListFirewallPoliciesResponse::firewallPolicies)).setter(ListFirewallPoliciesResponse.setter(Builder::firewallPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallPolicyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALL_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFirewallPoliciesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<FirewallPolicyMetadata> firewallPolicies;

    private ListFirewallPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallPolicies = builder.firewallPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewallPolicies() {
        return this.firewallPolicies != null && !(this.firewallPolicies instanceof SdkAutoConstructList);
    }

    public final List<FirewallPolicyMetadata> firewallPolicies() {
        return this.firewallPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallPolicies() ? this.firewallPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallPoliciesResponse)) {
            return false;
        }
        ListFirewallPoliciesResponse other = (ListFirewallPoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewallPolicies() == other.hasFirewallPolicies() && Objects.equals(this.firewallPolicies(), other.firewallPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallPoliciesResponse").add("NextToken", (Object)this.nextToken()).add("FirewallPolicies", this.hasFirewallPolicies() ? this.firewallPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FirewallPolicies": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("FirewallPolicies", FIREWALL_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallPoliciesResponse, T> g) {
        return obj -> g.apply((ListFirewallPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallPolicyMetadata> firewallPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallPoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewallPolicies(model.firewallPolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallPolicyMetadata.Builder> getFirewallPolicies() {
            List<FirewallPolicyMetadata.Builder> result = FirewallPoliciesCopier.copyToBuilder(this.firewallPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallPolicies(Collection<FirewallPolicyMetadata.BuilderImpl> firewallPolicies) {
            this.firewallPolicies = FirewallPoliciesCopier.copyFromBuilder(firewallPolicies);
        }

        @Override
        public final Builder firewallPolicies(Collection<FirewallPolicyMetadata> firewallPolicies) {
            this.firewallPolicies = FirewallPoliciesCopier.copy(firewallPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallPolicies(FirewallPolicyMetadata ... firewallPolicies) {
            this.firewallPolicies(Arrays.asList(firewallPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallPolicies(Consumer<FirewallPolicyMetadata.Builder> ... firewallPolicies) {
            this.firewallPolicies(Stream.of(firewallPolicies).map(c -> (FirewallPolicyMetadata)((FirewallPolicyMetadata.Builder)FirewallPolicyMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallPoliciesResponse build() {
            return new ListFirewallPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallPoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder firewallPolicies(Collection<FirewallPolicyMetadata> var1);

        public Builder firewallPolicies(FirewallPolicyMetadata ... var1);

        public Builder firewallPolicies(Consumer<FirewallPolicyMetadata.Builder> ... var1);
    }
}

