/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.VpcEndpointAssociationMetadata;

public class ListVpcEndpointAssociationsPublisher
implements SdkPublisher<ListVpcEndpointAssociationsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListVpcEndpointAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVpcEndpointAssociationsPublisher(NetworkFirewallAsyncClient client, ListVpcEndpointAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVpcEndpointAssociationsPublisher(NetworkFirewallAsyncClient client, ListVpcEndpointAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVpcEndpointAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVpcEndpointAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpcEndpointAssociationMetadata> vpcEndpointAssociations() {
        Function<ListVpcEndpointAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcEndpointAssociations() != null) {
                return response.vpcEndpointAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVpcEndpointAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVpcEndpointAssociationsResponseFetcher
    implements AsyncPageFetcher<ListVpcEndpointAssociationsResponse> {
        private ListVpcEndpointAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcEndpointAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVpcEndpointAssociationsResponse> nextPage(ListVpcEndpointAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcEndpointAssociationsPublisher.this.client.listVpcEndpointAssociations(ListVpcEndpointAssociationsPublisher.this.firstRequest);
            }
            return ListVpcEndpointAssociationsPublisher.this.client.listVpcEndpointAssociations((ListVpcEndpointAssociationsRequest)((Object)ListVpcEndpointAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

