/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.RuleSummariesCopier;
import software.amazon.awssdk.services.networkfirewall.model.RuleSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Summary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Summary> {
    private static final SdkField<List<RuleSummary>> RULE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleSummaries").getter(Summary.getter(Summary::ruleSummaries)).setter(Summary.setter(Builder::ruleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Summary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RuleSummary> ruleSummaries;

    private Summary(BuilderImpl builder) {
        this.ruleSummaries = builder.ruleSummaries;
    }

    public final boolean hasRuleSummaries() {
        return this.ruleSummaries != null && !(this.ruleSummaries instanceof SdkAutoConstructList);
    }

    public final List<RuleSummary> ruleSummaries() {
        return this.ruleSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSummaries() ? this.ruleSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)obj;
        return this.hasRuleSummaries() == other.hasRuleSummaries() && Objects.equals(this.ruleSummaries(), other.ruleSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"Summary").add("RuleSummaries", this.hasRuleSummaries() ? this.ruleSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSummaries": {
                return Optional.ofNullable(clazz.cast(this.ruleSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RuleSummary>>> map = new HashMap<String, SdkField<List<RuleSummary>>>();
        map.put("RuleSummaries", RULE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Summary, T> g) {
        return obj -> g.apply((Summary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RuleSummary> ruleSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Summary model) {
            this.ruleSummaries(model.ruleSummaries);
        }

        public final List<RuleSummary.Builder> getRuleSummaries() {
            List<RuleSummary.Builder> result = RuleSummariesCopier.copyToBuilder(this.ruleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSummaries(Collection<RuleSummary.BuilderImpl> ruleSummaries) {
            this.ruleSummaries = RuleSummariesCopier.copyFromBuilder(ruleSummaries);
        }

        @Override
        public final Builder ruleSummaries(Collection<RuleSummary> ruleSummaries) {
            this.ruleSummaries = RuleSummariesCopier.copy(ruleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSummaries(RuleSummary ... ruleSummaries) {
            this.ruleSummaries(Arrays.asList(ruleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSummaries(Consumer<RuleSummary.Builder> ... ruleSummaries) {
            this.ruleSummaries(Stream.of(ruleSummaries).map(c -> (RuleSummary)((RuleSummary.Builder)RuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Summary build() {
            return new Summary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Summary> {
        public Builder ruleSummaries(Collection<RuleSummary> var1);

        public Builder ruleSummaries(RuleSummary ... var1);

        public Builder ruleSummaries(Consumer<RuleSummary.Builder> ... var1);
    }
}

