/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FlowFilter;
import software.amazon.awssdk.services.networkfirewall.model.FlowFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowOperation> {
    private static final SdkField<Integer> MINIMUM_FLOW_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumFlowAgeInSeconds").getter(FlowOperation.getter(FlowOperation::minimumFlowAgeInSeconds)).setter(FlowOperation.setter(Builder::minimumFlowAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumFlowAgeInSeconds").build()}).build();
    private static final SdkField<List<FlowFilter>> FLOW_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FlowFilters").getter(FlowOperation.getter(FlowOperation::flowFilters)).setter(FlowOperation.setter(Builder::flowFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_FLOW_AGE_IN_SECONDS_FIELD, FLOW_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minimumFlowAgeInSeconds;
    private final List<FlowFilter> flowFilters;

    private FlowOperation(BuilderImpl builder) {
        this.minimumFlowAgeInSeconds = builder.minimumFlowAgeInSeconds;
        this.flowFilters = builder.flowFilters;
    }

    public final Integer minimumFlowAgeInSeconds() {
        return this.minimumFlowAgeInSeconds;
    }

    public final boolean hasFlowFilters() {
        return this.flowFilters != null && !(this.flowFilters instanceof SdkAutoConstructList);
    }

    public final List<FlowFilter> flowFilters() {
        return this.flowFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumFlowAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowFilters() ? this.flowFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowOperation)) {
            return false;
        }
        FlowOperation other = (FlowOperation)obj;
        return Objects.equals(this.minimumFlowAgeInSeconds(), other.minimumFlowAgeInSeconds()) && this.hasFlowFilters() == other.hasFlowFilters() && Objects.equals(this.flowFilters(), other.flowFilters());
    }

    public final String toString() {
        return ToString.builder((String)"FlowOperation").add("MinimumFlowAgeInSeconds", (Object)this.minimumFlowAgeInSeconds()).add("FlowFilters", this.hasFlowFilters() ? this.flowFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumFlowAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.minimumFlowAgeInSeconds()));
            }
            case "FlowFilters": {
                return Optional.ofNullable(clazz.cast(this.flowFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MinimumFlowAgeInSeconds", MINIMUM_FLOW_AGE_IN_SECONDS_FIELD);
        map.put("FlowFilters", FLOW_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowOperation, T> g) {
        return obj -> g.apply((FlowOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumFlowAgeInSeconds;
        private List<FlowFilter> flowFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowOperation model) {
            this.minimumFlowAgeInSeconds(model.minimumFlowAgeInSeconds);
            this.flowFilters(model.flowFilters);
        }

        public final Integer getMinimumFlowAgeInSeconds() {
            return this.minimumFlowAgeInSeconds;
        }

        public final void setMinimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds) {
            this.minimumFlowAgeInSeconds = minimumFlowAgeInSeconds;
        }

        @Override
        public final Builder minimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds) {
            this.minimumFlowAgeInSeconds = minimumFlowAgeInSeconds;
            return this;
        }

        public final List<FlowFilter.Builder> getFlowFilters() {
            List<FlowFilter.Builder> result = FlowFiltersCopier.copyToBuilder(this.flowFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowFilters(Collection<FlowFilter.BuilderImpl> flowFilters) {
            this.flowFilters = FlowFiltersCopier.copyFromBuilder(flowFilters);
        }

        @Override
        public final Builder flowFilters(Collection<FlowFilter> flowFilters) {
            this.flowFilters = FlowFiltersCopier.copy(flowFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowFilters(FlowFilter ... flowFilters) {
            this.flowFilters(Arrays.asList(flowFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowFilters(Consumer<FlowFilter.Builder> ... flowFilters) {
            this.flowFilters(Stream.of(flowFilters).map(c -> (FlowFilter)((FlowFilter.Builder)FlowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FlowOperation build() {
            return new FlowOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowOperation> {
        public Builder minimumFlowAgeInSeconds(Integer var1);

        public Builder flowFilters(Collection<FlowFilter> var1);

        public Builder flowFilters(FlowFilter ... var1);

        public Builder flowFilters(Consumer<FlowFilter.Builder> ... var1);
    }
}

